\name{computeIBS}
\alias{computeIBS}
\title{
Compute integrated Brier score
}
\description{
Compute integrated Brier score for a prediction model.
}
\usage{
computeIBS(model, y, x, y.new, x.new, cvPar = NULL, maxtime = NULL,
           cens.model = "marginal", offset = NULL, offset.new = NULL)
}
\arguments{
  \item{model}{R-object with the prediction model for which the integrated Brier score should be computed. Supported classes are \code{coxph}, \code{glmboost}, \code{CoxBoost} and \code{coxnet}.}
  \item{y}{survival outcome from the training set (either a matrix with two columns or a Surv object).}
  \item{x}{independent data from the training set.}
  \item{y.new}{survival outcome from the validation set (either a matrix with two columns or a Surv object).}
  \item{x.new}{independent data from the validation set.}
  \item{cvPar}{R-object containing the information about the tuning parameter of the model. It is relevant only if the class of \code{model} is \code{glmboost} (in which case \code{cvPar} should be the result of \preformatted{cvrisk()}) or \code{coxnet} (in which case \code{cvPar} should be the result of \preformatted{cv.glmnet()}).}
  \item{maxtime}{upper bound for the computation of the integrated Brier score.}
  \item{cens.model}{method to estimate the inverse probability of censoring weights. Possible values are \code{marginal}, \code{cox}, \code{nonpar} and \code{aalen}, see package \pkg{pec} for further details.}
  \item{offset}{offset from the training set.}
  \item{offset.new}{offset from the validation data.}
}
\value{The integrated Brier score.}
\references{
E. Graf et al. (1999). Assessment and comparison of prognostic classification schemes for survival data. Statistics in Medicine 18, 2529-2545.
}
\author{Riccardo De Bin}
\seealso{\code{\link{computeCindex}}, \code{\link{computePEC}}}
\examples{
#   Generate some survival data with 10 informative covariates 
n <- 350; q <- 10; p<-300 
beta <- c(rep(10,3),rep(0,q-3),rep(0,p-7),rep(5,7))
x <- matrix(rnorm(n*(p+q)),n,p+q)
real.time <- -(log(runif(n)))/(10*exp(drop(x \%*\% beta)))
cens.time <- rexp(n,rate=1/10)
status <- ifelse(real.time <= cens.time,1,0)
obs.time <- ifelse(real.time <= cens.time,real.time,cens.time)
data<-data.frame(obs.time,status,x)
colnames(data)<-c('time','status',paste('Z',1:q,sep=''),paste('X',1:p,sep=''))
trainData<-data[1:250,]
validData<-data[251:350,]
# Cox model using the best 10 covariates selected via univariate selection
model<-coxph(Surv(time,status)~.,data=univariateSelection(data,nSel=10))

# compute integrated Brier score
computeIBS(model=model,y=trainData[,1:2],x=trainData[,-c(1:2)],
           y.new=validData[,1:2],x.new=validData[,-c(1:2)])
}

