\name{computePEC}
\alias{computePEC}

\title{
compute prediction error curves
}
\description{
compute prediction error curves for a model using package \pkg{pec}.
}
\usage{
computePEC(model, y, x, y.new, x.new, cvPar = NULL, cens.model = "marginal",
           offset = NULL, offset.new = NULL)
}
\arguments{
  \item{model}{R-object with the prediction model for which the integrated Brier score should be computed. Supported class are \code{coxph}, \code{glmboost}, \code{CoxBoost} and \code{coxnet}.}
  \item{y}{survival outcome from the training set (either a matrix with two columns or a Surv object).}
  \item{x}{independent data from the training set.}
  \item{y.new}{survival outcome from the validation set (either a matrix with two columns or a Surv object).}
  \item{x.new}{independent data from the validation set.}
  \item{cvPar}{R-object containing the information about the tuning parameter of the model. It is relevant only if the class of \code{model} is \code{glmboost} (in which case \code{cvPar} should be the result of \preformatted{cvrisk()}) or \code{coxnet} (in which case \code{cvPar} should be the result of \preformatted{cv.glmnet()}).}
  \item{cens.model}{method to estimate the inverse probability of censoring weights. Possible values are \code{marginal}, \code{cox}, \code{nonpar} and \code{aalen}, see package \pkg{pec} for further details.}
  \item{offset}{offset from the training set.}
  \item{offset.new}{offset from the validation data.}
}
\value{
A \code{pec} object containing the prediction error curves (see \code{library(pec)} for futher details).
}
\references{
Martin Schumacher, Harald Binder, and Thomas Gerds (2007). Assessment of survival prediction models based on microarray data. Bioinformatics 23, 1768-1774.

}
\author{Riccardo De Bin}
\seealso{\code{\link{computeCindex}}, \code{\link{computeIBS}}}
\examples{
#   Generate some survival data with 10 informative covariates 
n <- 350; q <- 10; p<-300 
beta <- c(rep(10,3),rep(0,q-3),rep(0,p-7),rep(5,7))
x <- matrix(rnorm(n*(p+q)),n,p+q)
real.time <- -(log(runif(n)))/(10*exp(drop(x \%*\% beta)))
cens.time <- rexp(n,rate=1/10)
status <- ifelse(real.time <= cens.time,1,0)
obs.time <- ifelse(real.time <= cens.time,real.time,cens.time)
data<-data.frame(obs.time,status,x)
colnames(data)<-c('time','status',paste('Z',1:q,sep=''),paste('X',1:p,sep=''))
trainData<-data[1:250,]
validData<-data[251:350,]
# Cox model using the best 10 covariates selected via univariate selection
model<-coxph(Surv(time,status)~.,data=univariateSelection(trainData,nSel=10))

# compute prediction error curves
predEC<-computePEC(model=model,y=trainData[,1:2],x=trainData[,-c(1:2)],
                   y.new=validData[,1:2],x.new=validData[,-c(1:2)])
plot(predEC)
}