\name{univariateSelection}
\alias{univariateSelection}
\title{
Univariate selection
}
\description{
Perform univariate selection by selecting the most relevant predictors usign the p-value of a likelihood ratio test on the nullity of a univariate Cox model regressor coefficient as criteria.
}
\usage{
univariateSelection(data, nSel, nCov = 0, nFav = 0, offset = NULL)
}

\arguments{
  \item{data}{data.frame with all the variables. The first column should contain the time, the second the censoring status (as codified in the package \pkg{survival}).
}
  \item{nSel}{tuning parameter indicating the number of predictors to select.}
  \item{nCov}{parameter indicating the eventual number of mandatory predictors to be included. The correspondent predictors must be contained in the columns of data [3:3+nCov].}
  \item{nFav}{parameter indicating the eventual number of mandatory predictors to be favored. The correspondent predictors must be contained in the columns of data [3+nCov:3+nFav+nCov].}
  \item{offset}{possible offset term.}
}
\value{
data.frame containing time, censoring status and the relevant predictors.
}
\details{
In order to fit a model with the result of an univariate selection procedure, simply use the command \code{mod1<-coxph(Surv(time, status)~.,data=univariateSelection(yourData)))}.
}
\author{Riccardo De Bin}
\seealso{\code{\link{cv.tuningParam}}, \code{\link{univariateSelection}}}
\examples{
#   Generate some survival data with 10 informative covariates 
n <- 250; q <- 10; p<-300 
beta <- c(rep(10,3),rep(0,q-3),rep(0,p-7),rep(5,7))
x <- matrix(rnorm(n*(p+q)),n,p+q)
real.time <- -(log(runif(n)))/(10*exp(drop(x \%*\% beta)))
cens.time <- rexp(n,rate=1/10)
status <- ifelse(real.time <= cens.time,1,0)
obs.time <- ifelse(real.time <= cens.time,real.time,cens.time)
data<-data.frame(obs.time,status,x)
colnames(data)<-c('time','status',paste('Z',1:q,sep=''),paste('X',1:p,sep=''))

# univariate selection
onlySel<-univariateSelection(data,nSel=10)
}
