computeCindex<-function(model,y,x,y.new,x.new,cvPar=NULL,cens.model='marginal',offset=NULL,offset.new=NULL)
{
  # model: model use for prediction (supported: coxph, glmboost, glmnet, CoxBoost)
  # y: outcome in the training set (either a matrix with two columns or a Surv object)
  # x: data from the training set
  # y.new: outcome in the validation set (either a matrix with two columns or a Surv object)
  # x.new: data from the validation set
  # cvPar: cv parameter (for glmboost and glmnet)
  # cens.model: censoring model (see package pec)
  # offset: offset in training data
  # offset.new: offset in validation data
  require(mboost)
  require(glmnet)
  if(is.Surv(y))
  {
    y<-cbind(y[,1],y[,2])
  }
  colnames(y)<-c('time','status')
  if(is.null(offset)) offset<-rep(0,length(y[,1]))
  if(class(model)[1]=='glmboost'&is.null(cvPar)) stop('for glmboost is necessary to specify the optimal number of step')
  if(class(model)[1]=='coxnet'&is.null(cvPar)) stop('for lasso is necessary to specify the lambda.min')
  
  coxMod<-switch(class(model)[1], # select the class of the model
                 CoxBoost={
                   ifelse(is.vector(x),dataTmp<-data.frame(y,x),dataTmp<-data.frame(y,x[,model$coefficients[model$stepno+1,]!=0]))
                   names(dataTmp)<-c('time','status',colnames(x)[model$coefficients[model$stepno+1,]!=0])
                   coxph(Surv(time,status)~offset(offset)+.,data=dataTmp,init=model$coefficients[model$stepno+1,model$coefficients[model$stepno+1,]!=0],iter=0)},
                 glmboost={
                   ifelse(is.vector(x),dataTmp<-data.frame(y,x),dataTmp<-data.frame(y,x[,names(coef(model[mstop(cvPar)]))]))
                   names(dataTmp)<-c('time','status',names(coef(model[mstop(cvPar)])))
                   coxph(Surv(time,status)~offset(offset)+.,data=dataTmp,init=coef(model[mstop(cvPar)]),iter=0)},
                 coxnet={
                   ifelse(is.vector(x),dataTmp<-data.frame(y,x),dataTmp<-data.frame(y,x[,rownames(model$beta)[model$beta[,which(model$lambda==cvPar$lambda.min)]!=0]]))
                   names(dataTmp)<-c('time','status',rownames(model$beta)[model$beta[,which(model$lambda==cvPar$lambda.min)]!=0])
                   coxph(Surv(time,status)~offset(offset)+.,data=dataTmp,init=coef(model,s=cvPar$lambda.min)[coef(model,s=cvPar$lambda.min)!=0],iter=0)},
                 coxph={
                   ifelse(is.vector(x),dataTmp<-data.frame(y,x),dataTmp<-data.frame(y,x[,names(model$coefficients)]))
                   names(dataTmp)<-c('time','status',names(model$coefficients))
                   coxph(Surv(time,status)~offset(offset)+.,data=dataTmp,init=model$coefficients,iter=0)})
  if(is.null(coxMod)) stop(paste(class(model),'not supported',sep=' '))
  
  if(is.Surv(y.new))
  {
    y.new<-cbind(y.new[,1],y.new[,2])
  }
  if(is.null(offset.new)) offset.new<-rep(0,length(y.new[,1]))
  colnames(y.new)<-c('time','status')
  ifelse(is.vector(x.new),dataTmpNew<-data.frame(y.new,x.new,offset.new),dataTmpNew<-data.frame(y.new,x.new[,names(coxMod$coefficients)],offset.new))
  names(dataTmpNew)<-c('time','status',names(coxMod$coefficients),'offset')
  
  as.numeric(pec::cindex(list(coxMod),formula=coxMod$formula,data=dataTmpNew,cens.model=cens.model)$AppCindex)
}
