computeIBS<-function(model,y,x,y.new,x.new,cvPar=NULL,maxtime=NULL,cens.model='marginal',offset=NULL,offset.new=NULL)
{
  # model: model use for prediction (supported: coxph, glmboost, glmnet, CoxBoost)
  # y: outcome in the training set (either a matrix with two columns or a Surv object)
  # x: data from the training set
  # y.new: outcome in the validation set (either a matrix with two columns or a Surv object)
  # x.new: data from the validation set
  # cvPar: cv parameter (for glmboost and glmnet)
  # maxtime: upper bound for computing integrated Brier score
  # cens.model: censoring model (see package pec)
  # offset: offset in training data
  # offset.new: offset in validation data
  predEC<-computePEC(model,y,x,y.new,x.new,cvPar=cvPar,cens.model=cens.model,offset=offset,offset.new=offset.new)
  if(is.null(maxtime)) maxtime<-sort(y.new[,1],decreasing=TRUE)
  out<-pec::ibs(predEC,times=maxtime[1])[2] # compute IBS (if time is not specified, use the largest one which gives no problem)
  while(sum(is.na(out))>0)
  {
    if (length(maxtime)==1) stop('wrong specification of maxtime in IBS computation')
    maxtime<-maxtime[-1]
    out<-pec::ibs(predEC,times=maxtime[1])[2]
  }
  as.numeric(out)
}
