################################################################
## Usage:  Print row min/max positions in boldface for latex
## Author: Nikolay.Robinzonov@stat.uni-muenchen.de
################################################################
boldify <- function(tab, bld = NULL, cnames = TRUE, rnames = TRUE,
                    color = "black", NA.char = " ")
{ 
  if(!class(tab) %in% c("matrix","data.frame"))
    stop("You must provide either 'matrix' or 'data.frame'.\n")
  
  ## column names
  if(cnames){
    if(length(colnames(tab)) == 0)
      warning("No 'colnames' provided but still required.")
    frn <- ifelse(rnames, "&","")
    cat(frn, paste(colnames(tab), collapse = " & "), "\\\\ \\hline \n")
  }
  
  ## find the min/max positions 
  ibld <- 1:ncol(tab)                   # nothing will happen if bld == NULL
  char.cols <- rep(FALSE,ncol(tab))     # no character columns if bld == NULL
  if(!is.null(bld)){
    ## data.frames could be tricky because of character columns (find them)
    char.cols <- do.call("c",lapply(as.data.frame(tab),'class')) %in% "character"
    work <- tab[,!char.cols, drop = FALSE]
    for(i in 1:nrow(work))
      ibld[i] <- ifelse(bld == "min", which.min(work[i,]), which.max(work[i,]))
    for(i in which(char.cols))
      ibld[ibld >= i] <- ibld[ibld >= i] + 1
  }
  
  mypaste <- function(x,...) paste(format(x,drop0trailing=FALSE), ...)
  
  mcat <- function(i) {
    p <- ibld[i]
    lx <- rep(" ",ncol(tab))
    lx[!char.cols] <- mypaste(as.matrix(tab[i,!char.cols]))
    lx[char.cols] <- paste(tab[i,char.cols])
    lx[is.na(tab[i,])] <- NA.char       # NA's
    x <- lx[p]
    xx <- paste("\\textcolor{",color,"}{\\textbf{",x,"}}", sep="")
    lx[p] <- ifelse(is.null(bld),x,xx)
    lx <- paste(lx, collapse=" & ")
    rn <- ifelse(rnames, paste(rownames(tab)[i], " &"),"")
    cat(rn, lx, " \\\\ \n")
  }
  
  tmp <- sapply(1:nrow(tab), mcat)
}

#################### examples ####################
## set.seed(2485); (tab <- round(matrix(rnorm(60, sd = 10), 6),2))
## colnames(tab) <- LETTERS[1:ncol(tab)]; rownames(tab) <- letters[1:nrow(tab)]
## boldify(tab)
## boldify(tab, "max", color = "red")
## boldify(tab, rnames = FALSE, cnames = FALSE, color="black")
##################################################
