# File for reproducing the analyses presented in the paper
# "Complexity selection and CV in lasso and sparse PLS with high-dimensional data"
# by A.-L. Boulesteix, A. Richter and C. Bernau

# Figure 2

source("fun.r")

pdf("Figure2.pdf",width=12,height=3)

par(mfrow=c(1,4))
load("results/resultancona1_spls.RData")
boxplot(resultancona1_spls$numberopt[1:200,1],resultancona1_spls$numberopt[1:200,2],
        resultancona1_spls$numberopt[1:200,3],resultancona1_spls$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Ancona",
        xlab="",ylab="")
        
load("results/resultscherzer1_spls.RData")
boxplot(resultscherzer1_spls$numberopt[1:200,1],resultscherzer1_spls$numberopt[1:200,2],
        resultscherzer1_spls$numberopt[1:200,3],resultscherzer1_spls$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)),main="Scherzer",
        xlab="",ylab="")
        
load("results/resultsingh1_spls.RData")  
boxplot(resultsingh1_spls$numberopt[,1],resultsingh1_spls$numberopt[,2],
        resultsingh1_spls$numberopt[,3],resultsingh1_spls$numberopt[,4],
        names=as.character(c(3,5,10,20)),main="Singh",
        xlab="",ylab="")
     
load("results/resulttang1_spls250.RData")  
boxplot(resulttang1_spls$numberopt[1:200,1],resulttang1_spls$numberopt[1:200,2],
        resulttang1_spls$numberopt[1:200,3],resulttang1_spls$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Tang",
        xlab="",ylab="")   
dev.off()
