# File for reproducing the analyses presented in the paper
# "Complexity selection and CV in lasso and sparse PLS with high-dimensional data"
# by A.-L. Boulesteix, A. Richter and C. Bernau

# Figure 3

pdf("Figure3.pdf",height=3,width=10)

par(mfrow=c(1,5))
load("results/result2_0.1_ancona.RData")
load("results/result2_0.2_ancona.RData")
load("results/result2_0.05_ancona.RData")

boxplot(result2_0.05_ancona$numberopt, result2_0.1_ancona$numberopt, result2_0.2_ancona$numberopt,
        xlab="subsamples",ylab="Number of features",main="LOOCV\n Ancona",
        names=c("95%","90%","80%"),
        ylim=c(0,max(c(result2_0.05_ancona$numberopt,result2_0.1_ancona$numberopt,result2_0.2_ancona$numberopt))))

#######


load("results/result2_0.1_tang.RData")
load("results/result2_0.2_tang.RData")
load("results/result2_0.05_tang.RData")

boxplot(result2_0.05_tang$numberopt, result2_0.1_tang$numberopt, result2_0.2_tang$numberopt,
        xlab="subsamples",main="LOOCV\n Tang",
        names=c("95%","90%","80%"),
        ylim=c(0,max(c(result2_0.05_tang$numberopt, result2_0.1_tang$numberopt,result2_0.2_tang$numberopt))))

########


load("results/result2_0.1_wang.RData")
load("results/result2_0.2_wang.RData")
load("results/result2_0.05_wang.RData")

boxplot(result2_0.05_wang$numberopt, result2_0.1_wang$numberopt, result2_0.2_wang$numberopt,
        xlab="subsamples", main="LOOCV\n Wang",
        names=c("95%","90%","80%"),
        ylim=c(0,max(c(result2_0.05_wang$numberopt,result2_0.1_wang$numberopt,result2_0.2_wang$numberopt))))

#######

load("results/result2_0.1_singh.RData")
load("results/result2_0.2_singh.RData")
load("results/result2_0.05_singh.RData")

boxplot(result2_0.05_singh$numberopt, result2_0.1_singh$numberopt, result2_0.2_singh$numberopt,
        xlab="subsamples",main="LOOCV\n Singh",
        names=c("95%","90%","80%"),
        ylim=c(0,max(c(result2_0.05_singh$numberopt,result2_0.1_singh$numberopt,result2_0.2_singh$numberopt))))

#######

load("results/result2_0.1_scherzer.RData")
load("results/result2_0.2_scherzer.RData")
load("results/result2_0.05_scherzer.RData")


boxplot(result2_0.05_scherzer$numberopt, result2_0.1_scherzer$numberopt, result2_0.2_scherzer$numberopt,
        xlab="subsamples",main="LOOCV\n Scherzer",
        names=c("95%","90%","80%"),
        ylim=c(0,max(c(result2_0.1_scherzer$numberopt,result2_0.05_scherzer$numberopt,result2_0.2_scherzer$numberopt))))

dev.off()
