# File for reproducing the analyses presented in the paper
# "Complexity selection and CV in lasso and sparse PLS with high-dimensional data"
# by A.-L. Boulesteix, A. Richter and C. Bernau

# Study 2, all data sets, 80% subsampling 

source("fun.r")

library(glmnet)
library(affy)
niter<-100

##############
### Ancona ###
##############

load("../realdata/ancona06/RMA.RData")
load("../realdata/ancona06/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.2_ancona<-lassoCV2(X=X,y=y,niter=niter,exclude=0.2)
save(result2_0.2_ancona,file="result2_0.2_ancona.RData")
rm(result2_0.2_ancona)

################
### Scherzer ###
################

load("../realdata/scherzer07/RMA.RData")
load("../realdata/scherzer07/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.2_scherzer<-lassoCV2(X=X,y=y,niter=niter,exclude=0.2)
save(result2_0.2_scherzer,file="result2_0.2_scherzer.RData")
rm(result2_0.2_scherzer)

############
### Tang ###
############

load("../realdata/tang09/RMA.RData")
load("../realdata/tang09/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.2_tang<-lassoCV2(X=X,y=y,niter=niter,exclude=0.2)
save(result2_0.2_tang,file="result2_0.2_tang.RData")
rm(result2_0.2_tang)

#############
### Singh ###
#############

load("../realdata/singh02/RMA.RData")
load("../realdata/singh02/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.2_singh<-lassoCV2(X=X,y=y,niter=niter,exclude=0.2)
save(result2_0.2_singh,file="result2_0.2_singh.RData")
rm(result2_0.2_singh)



############
### Wang ###
############

load("../realdata/wang05/RMA.RData")
load("../realdata/wang05/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.2_wang<-lassoCV2(X=X,y=y,niter=niter,exclude=0.2)
save(result2_0.2_wang,file="result2_0.2_wang.RData")
rm(result2_0.2_wang)









