# File for reproducing the analyses presented in the paper
# "Complexity selection and CV in lasso and sparse PLS with high-dimensional data"
# by A.-L. Boulesteix, A. Richter and C. Bernau

# Figure 1

source("fun.r")

load("results/result1_ancona.RData")
result1_ancona_CV5<-cviter(result1_ancona,ncv=5)
result1_ancona_CV10<-cviter(result1_ancona,ncv=10)

load("results/result1_scherzer.RData")
result1_scherzer_CV5<-cviter(result1_scherzer,ncv=5)
result1_scherzer_CV10<-cviter(result1_scherzer,ncv=10)

load("results/result1_wang.RData")
result1_wang_CV5<-cviter(result1_wang,ncv=5)
result1_wang_CV10<-cviter(result1_wang,ncv=10)

load("results/result1_singh.RData")
result1_singh_CV5<-cviter(result1_singh,ncv=5)
result1_singh_CV10<-cviter(result1_singh,ncv=10)

load("results/result1_tang.RData")
result1_tang_CV10<-cviter(result1_tang,ncv=10)
result1_tang_CV5<-cviter(result1_tang,ncv=5)


pdf("Figure1.pdf",width=10,height=6)

par(mfrow=c(3,5))
boxplot(result1_ancona$numberopt[1:200,1],result1_ancona$numberopt[1:200,2],
        result1_ancona$numberopt[1:200,3],result1_ancona$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Ancona",
        xlab="",ylab="")

boxplot(result1_scherzer$numberopt[1:200,1],result1_scherzer$numberopt[1:200,2],
        result1_scherzer$numberopt[1:200,3],result1_scherzer$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)),main="Scherzer",
        xlab="",ylab="")
        

boxplot(result1_wang$numberopt[1:200,1],result1_wang$numberopt[1:200,2],
        result1_wang$numberopt[1:200,3],result1_wang$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)),main="Wang",
        xlab="",ylab="")

boxplot(result1_singh$numberopt[,1],result1_singh$numberopt[,2],
        result1_singh$numberopt[,3],result1_singh$numberopt[,4],
        names=as.character(c(3,5,10,20)),main="Singh",
        xlab="",ylab="")
        
boxplot(result1_tang$numberopt[1:200,1],result1_tang$numberopt[1:200,2],
        result1_tang$numberopt[1:200,3],result1_tang$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Tang",
        xlab="",ylab="")   
             
## CV5
boxplot(result1_ancona_CV5$numberopt[1:200,1],result1_ancona_CV5$numberopt[1:200,2],
        result1_ancona_CV5$numberopt[1:200,3],result1_ancona_CV5$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Ancona   5 x CV",
        xlab="",ylab="Number of features")
        
boxplot(result1_scherzer_CV5$numberopt[1:200,1],result1_scherzer_CV5$numberopt[1:200,2],
        result1_scherzer_CV5$numberopt[1:200,3],result1_scherzer_CV5$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Scherzer   5 x CV",
        xlab="",ylab="Number of features")

boxplot(result1_wang_CV5$numberopt[1:200,1],result1_wang_CV5$numberopt[1:200,2],
        result1_wang_CV5$numberopt[1:200,3],result1_wang_CV5$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Wang   5 x CV",
        xlab="",ylab="Number of features")

boxplot(result1_singh_CV5$numberopt[,1],result1_singh_CV5$numberopt[,2],
        result1_singh_CV5$numberopt[,3],result1_singh_CV5$numberopt[,4],
        names=as.character(c(3,5,10,20)), main="Singh   5 x CV",
        xlab="",ylab="Number of features")        

boxplot(result1_tang_CV5$numberopt[1:200,1],result1_tang_CV5$numberopt[1:200,2],
        result1_tang_CV5$numberopt[1:200,3],result1_tang_CV5$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)),  main="Tang   5 x CV",
        xlab="",ylab="Number of features")

## CV10
boxplot(result1_ancona_CV10$numberopt[1:200,1],result1_ancona_CV10$numberopt[1:200,2],
        result1_ancona_CV10$numberopt[1:200,3],result1_ancona_CV10$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Ancona   10 x CV",
        xlab="number of CV folds",ylab="")

boxplot(result1_scherzer_CV10$numberopt[1:200,1],result1_scherzer_CV10$numberopt[1:200,2],
        result1_scherzer_CV10$numberopt[1:200,3],result1_scherzer_CV10$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Scherzer  10 x CV",
        xlab="number of CV folds",ylab="")

boxplot(result1_wang_CV10$numberopt[1:200,1],result1_wang_CV10$numberopt[1:200,2],
        result1_wang_CV10$numberopt[1:200,3],result1_wang_CV10$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Wang   10 x CV",
        xlab="number of CV folds",ylab="")   

boxplot(result1_singh_CV10$numberopt[,1],result1_singh_CV10$numberopt[,2],
        result1_singh_CV10$numberopt[,3],result1_singh_CV10$numberopt[,4],
        names=as.character(c(3,5,10,20)),  main="Singh   10 x CV",
        xlab="number of CV folds",ylab="")

boxplot(result1_tang_CV10$numberopt[1:200,1],result1_tang_CV10$numberopt[1:200,2],
        result1_tang_CV10$numberopt[1:200,3],result1_tang_CV10$numberopt[1:200,4],
        names=as.character(c(3,5,10,20)), main="Tang   10 x CV",
        xlab="number of CV folds",ylab="")

dev.off()

