# File for reproducing the analyses presented in the paper
# "Complexity selection and CV in lasso and sparse PLS with high-dimensional data"
# by A.-L. Boulesteix, A. Richter and C. Bernau

# Study 1, Scherzer data set 

source("fun.r")

library(glmnet)
library(affy)
niter<-2000

################
### Scherzer ###
################

load("../realdata/scherzer07/RMA.RData")
load("../realdata/scherzer07/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result1_scherzer<-lassoCV(X=X,y=y,niter=niter,Kvec=c(3,5,10,20))
save(result1_scherzer,file="results/result1_scherzer.RData")
rm(result1_scherzer)
