# File for reproducing the analyses presented in the paper
# "Complexity selection and CV in lasso and sparse PLS with high-dimensional data"
# by A.-L. Boulesteix, A. Richter and C. Bernau

# Study 2, all data sets, 90% subsampling 

source("fun.r")

library(glmnet)
library(affy)
niter<-100


##############
### Ancona ###
##############

load("../realdata/ancona06/RMA.RData")
load("../realdata/ancona06/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.1_ancona<-lassoCV2(X=X,y=y,niter=niter,exclude=0.1)
save(result2_0.1_ancona,file="results/result2_0.1_ancona.RData")
rm(result2_0.1_ancona)

################
### Scherzer ###
################

load("../realdata/scherzer07/RMA.RData")
load("../realdata/scherzer07/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.1_scherzer<-lassoCV2(X=X,y=y,niter=niter,exclude=0.1)
save(result2_0.1_scherzer,file="results/result2_0.1_scherzer.RData")
rm(result2_0.1_scherzer)

############
### Tang ###
############

load("../realdata/tang09/RMA.RData")
load("../realdata/tang09/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.1_tang<-lassoCV2(X=X,y=y,niter=niter,exclude=0.1)
save(result2_0.1_tang,file="results/result2_0.1_tang.RData")
rm(result2_0.1_tang)

#############
### Singh ###
#############

load("../realdata/singh02/RMA.RData")
load("../realdata/singh02/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.1_singh<-lassoCV2(X=X,y=y,niter=niter,exclude=0.1)
save(result2_0.1_singh,file="results/result2_0.1_singh.RData")
rm(result2_0.1_singh)



############
### Wang ###
############

load("../realdata/wang05/RMA.RData")
load("../realdata/wang05/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
result2_0.1_wang<-lassoCV2(X=X,y=y,niter=niter,exclude=0.1)
save(result2_0.1_wang,file="results/result2_0.1_wang.RData")
rm(result2_0.1_wang)









