# File for reproducing the analyses presented in the paper
# "Complexity selection and CV in lasso and sparse PLS with high-dimensional data"
# by A.-L. Boulesteix, A. Richter and C. Bernau

# Study 3, all data sets, p*=500 selected variables

source("fun.r")                                                                                                                     

library(glmnet)
library(affy)
niter<-1000


##############
### Ancona ###
##############

load("../realdata/ancona06/RMA.RData")
load("../realdata/ancona06/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
pval<-apply(X,MARGIN=2,FUN=function(x,y) return(t.test(x[y==1],x[y==2])$p.value),y=y)
Xsel<-X[,order(pval)[1:500]]
result3p500_ancona<-lassoCV(X=Xsel,y=y,niter=niter,Kvec=c(3,5,10,20))
save(result3p500_ancona,file="results/result3p500_ancona.RData")
rm(result3p500_ancona)


################
### Scherzer ###
################

load("../realdata/scherzer07/RMA.RData")
load("../realdata/scherzer07/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
pval<-apply(X,MARGIN=2,FUN=function(x,y) return(t.test(x[y==1],x[y==2])$p.value),y=y)
Xsel<-X[,order(pval)[1:500]]
result3p500_scherzer<-lassoCV(X=Xsel,y=y,niter=niter,Kvec=c(3,5,10,20))
save(result3p500_scherzer,file="results/result3p500_scherzer.RData")
rm(result3p500_scherzer)

############
### Tang ###
############

load("../realdata/tang09/RMA.RData")
load("../realdata/tang09/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
pval<-apply(X,MARGIN=2,FUN=function(x,y) return(t.test(x[y==1],x[y==2])$p.value),y=y)
Xsel<-X[,order(pval)[1:500]]
result3p500_tang<-lassoCV(X=Xsel,y=y,niter=niter,Kvec=c(3,5,10,20))
save(result3p500_tang,file="results/result3p500_tang.RData")
rm(result3p500_tang)

#############
### Singh ###
#############

load("../realdata/singh02/RMA.RData")
load("../realdata/singh02/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
pval<-apply(X,MARGIN=2,FUN=function(x,y) return(t.test(x[y==1],x[y==2])$p.value),y=y)
Xsel<-X[,order(pval)[1:500]]
result3p500_singh<-lassoCV(X=Xsel,y=y,niter=niter,Kvec=c(3,5,10,20))
save(result3p500_singh,file="results/result3p500_singh.RData")
rm(result3p500_singh)


############
### Wang ###
############

load("../realdata/wang05/RMA.RData")
load("../realdata/wang05/y.RData")
y<-as.numeric(y)
X<-t(exprs(X))
pval<-apply(X,MARGIN=2,FUN=function(x,y) return(t.test(x[y==1],x[y==2])$p.value),y=y)
Xsel<-X[,order(pval)[1:500]]
result3p500_wang<-lassoCV(X=Xsel,y=y,niter=niter,Kvec=c(3,5,10,20))
save(result3p500_wang,file="results/result3p500_wang.RData")
rm(result3p500_wang)

