 ######################################
# Real data: dataset from Segal et al. #
 ######################################

# Clear environnement
rm(list=ls())

# Load packages
require(pacose)
require(irr)
require(fdrtool)

# IMPORTANT: Set working directory here
setwd("/volatile/PACOSE_Final")

# Load data
x <- read.table("segal_et_al_2001_property.dat",header=TRUE,sep=",")[,-(1:2)]
p <- ncol(x) ; n <- nrow(x)
nfold <- 10
# Estimate the partial correlation matrix estimated with ridge.net
pcor0 <- matrix(NA,nfold,p*(p-1)/2)
# Estimate thepartial correlation matrix re-estimated with iPACOSE
pcor1 <- matrix(NA,nfold,p*(p-1)/2)
folds <- split(sample(1:n), rep(1:nfold, length = n))

pb <- txtProgressBar(style=3)
# 10-fold "like" analysis: 10 graphs are iteratively estimated 
# on 9 10th of the dataset with the method ridge.net and iPACOSE
for (j in 1:nfold) {
  index  <- folds[[j]]
  temp <- pcor.ridge.net <- ridge.net(x[-index,],k=k,lambda=10**seq(-3,3,l=20))$pcor
  cutoff <- fdrtool(temp[upper.tri(temp)], statistic = "correlation", plot = F,verbose=F)$param[1]
  temp[abs(temp) < cutoff] <- 0
  pcor0[j,] <- temp[upper.tri(temp)]
  temp2 <- ipacose(x=x,pc=pcor.ridge.net,method="pacose.ridge",cutoff=cutoff,gr=NULL,cv.method="HKB")$pcor_it
  pcor1[j,] <- temp2[upper.tri(temp2)]
  setTxtProgressBar(pb, j/nfold)
}
close(pb)

# The 10 graphs are then compared with Fleiss' Kappa
c(ridge.net = kappam.fleiss(t(pcor0!=0)+0)$value,
  iPACOSE   = kappam.fleiss(t(pcor1!=0)+0)$value) 
