 ################################################
# Figures: MSE of the partial correlation matrix #
 ################################################

# Clear environnement
rm(list=ls())

# Load packages
require(pacose)
require(glasso)

# IMPORTANT: Set working directory here
setwd("/volatile/PACOSE_Final")

# Source the function used to generate the MSE
source('functions/comparisonMethods_final.R')

cM1 <- comparisonMethods_final(p=50, n=100, niter=100, plot=T,barabasi=TRUE,decomp=TRUE)
cM2 <- comparisonMethods_final(p=100, n=50, niter=100, plot=T,barabasi=FALSE,decomp=FALSE)

methodNames  <- c("GeneNet","PACOSE(1)","PACOSE(2)","PACOSE(3)","PACOSE(4)","glasso","Wermuth","Whittaker","MVUE","SURE")
mse_cM1 <- t(sapply(cM1,function(z) sapply(z$result_pcor,function(mat) if(is.null(mat)) { NA } else { mean((mat - invcov2pcor(z$omega) )**2) }  )) )
mse_cM2 <- t(sapply(cM2,function(z) sapply(z$result_pcor,function(mat) if(is.null(mat)) { NA } else { mean((mat - invcov2pcor(z$omega) )**2) }  ))  )

pdf("figure2.pdf")
par(mar = c(6, 4, 2, 1) + 0.1)
boxplot(log(mse_cM1), main='p=50, n=100',
        xlab='',names=methodNames, ylab='MSE (log scale)',border=c(rep(1,ncol(mse_cM1)),2),las=2)
abline(v=1.5,col=1,lty=2)
dev.off()

pdf("figure3.pdf")
par(mar = c(6, 4, 2, 1) + 0.1)
boxplot(log(mse_cM2), main='p=100, n=50',
  xlab='',names=methodNames, ylab='MSE (log scale)',border=c(rep(1,ncol(mse_cM2)),2),las=2)
abline(v=1.5,col=1,lty=2)
dev.off()
