 ##############################
# Figures: sensibility and PPV #
 ##############################

# Clear environnement
rm(list=ls())

# Load packages
require(parcor)
require(pacose)

# IMPORTANT: Set working directory here
setwd("/volatile/PACOSE_Final")

# Source the function used to generate the sensitivity and the PPV
source("functions/newgraphestimation.R")

cutoffs <-  c(0.05,0.1,0.2,0.3)
grEst.pls1      <- newgraphestimation(p=50 , n=100, k=10, niter=100, cutoffs=cutoffs, method1="pls.net"     , method2="pacose.pls")
grEst.pls2      <- newgraphestimation(p=100, n=50 , k=10, niter=100, cutoffs=cutoffs, method1="pls.net"     , method2="pacose.pls")
grEst.ridge1    <- newgraphestimation(p=50 , n=100, k=10, niter=100, cutoffs=cutoffs, method1="ridge.net"   , method2="pacose.ridge")
grEst.ridge2    <- newgraphestimation(p=100, n=50 , k=10, niter=100, cutoffs=cutoffs, method1="ridge.net"   , method2="pacose.ridge")
grEst.lasso1    <- newgraphestimation(p=50 , n=100, k=10, niter=100, cutoffs=cutoffs, method1="adalasso.net", method2="pacose.adalasso")
grEst.lasso2    <- newgraphestimation(p=100, n=50 , k=10, niter=100, cutoffs=cutoffs, method1="adalasso.net", method2="pacose.adalasso")
grEst.adalasso1 <- newgraphestimation(p=50 , n=100, k=10, niter=100, cutoffs=cutoffs, method1="adalasso.net", method2="pacose.adalasso",adaptive=TRUE)
grEst.adalasso2 <- newgraphestimation(p=100, n=50 , k=10, niter=100, cutoffs=cutoffs, method1="adalasso.net", method2="pacose.adalasso",adaptive=TRUE)


pdf("figure4.pdf")
# (a) PLS, p=100 and n=50
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.pls1$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.pls1$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.pls1$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.pls1$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
# (b) PLS, p=50 and n=100
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.pls2$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.pls2$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.pls2$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.pls2$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
# (c) Ridge, p=100 and n=50
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.ridge1$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.ridge1$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.ridge1$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.ridge1$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
# (d) Ride, p=50 and n=100
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.ridge2$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.ridge2$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.ridge2$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.ridge2$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
dev.off()

pdf("figure4.pdf")
# (a) LASSO, p=100 and n=50
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.lasso1$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.lasso1$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.lasso1$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.lasso1$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
# (b) LASSO, p=50 and n=100
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.lasso2$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.lasso2$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.lasso2$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.lasso2$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
# (c) adaptive LASSO, p=100 and n=50
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.adalasso1$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.adalasso1$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.adalasso1$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.adalasso1$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
# (d) adaptive LASSO, p=50 and n=100
par(cex.axis=1.3,cex.lab=1.3,cex.main=1.3)
layout(1:2)
plot(cutoffs,grEst.adalasso2$sens_m,type="b",pch=16,ylim=0:1,ylab="Sensitivity",lwd=2)
points(cutoffs,grEst.adalasso2$sens_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
plot(cutoffs,grEst.adalasso2$ppv_m,type="b",pch=16,ylim=0:1,ylab="PPV",lwd=2)
points(cutoffs,grEst.adalasso2$ppv_0m,type="b",pch=16,ylim=0:1,col=2,lty=2,lwd=2)
dev.off()



