 ######################################
# Figures: Stability on simulated data #
 ######################################

# Clear environnement
rm(list=ls())

# Load packages
require(parcor)
require(irr)
require(mvtnorm)
require(fdrtool)
require(corpcor)
require(pacose)

# IMPORTANT: Set working directory here
setwd("/volatile/PACOSE_Final")

# Source the function used to generate the stability results
source('functions/stability_simulations.R')

# The results are generated over 50 independent runs
B <- 50
nfold <- 5
res.ridgeHKB1 <- res.ridgeHKB2 <- res.pls1   <- res.pls2   <- matrix(NA,B,2)
res.ridge1    <- res.ridge2    <- res.lasso1 <- res.lasso2 <- matrix(NA,B,2)
res.adalasso1 <- res.adalasso2 <- matrix(NA,B,2)
pb <- txtProgressBar(style=3)
for (i in 1:B) {
  res.ridgeHKB1[i,] <- stability_simulations(p=100 ,n=50, nfold=nfold, k=5, method1="ridge.net"   ,method2="pacose.ridge",cv.method="HKB")
  res.ridge1[i,]    <- stability_simulations(p=100 ,n=50, nfold=nfold, k=5, method1="ridge.net"   ,method2="pacose.ridge",cv.method="CV")
  res.pls1[i,]      <- stability_simulations(p=100 ,n=50, nfold=nfold, k=5, method1="pls.net"     ,method2="pacose.pls",cv.method="CV")
  res.lasso1[i,]    <- stability_simulations(p=100 ,n=50, nfold=nfold, k=5, method1="adalasso.net",method2="pacose.adalasso",cv.method="CV")
  res.adalasso1[i,] <- stability_simulations(p=100 ,n=50, nfold=nfold, k=5, method1="adalasso.net",method2="pacose.adalasso",cv.method="CV",adaptive=TRUE)
  res.ridgeHKB2[i,] <- stability_simulations(p=50 ,n=100, nfold=nfold, k=5, method1="ridge.net"   ,method2="pacose.ridge",cv.method="HKB")
  res.ridge2[i,]    <- stability_simulations(p=50 ,n=100, nfold=nfold, k=5, method1="ridge.net"   ,method2="pacose.ridge",cv.method="CV")
  res.pls2[i,]      <- stability_simulations(p=50 ,n=100, nfold=nfold, k=5, method1="pls.net"     ,method2="pacose.pls",cv.method="CV")
  res.lasso2[i,]    <- stability_simulations(p=50 ,n=100, nfold=nfold, k=5, method1="adalasso.net",method2="pacose.adalasso",cv.method="CV")
  res.adalasso2[i,] <- stability_simulations(p=50 ,n=100, nfold=nfold, k=5, method1="adalasso.net",method2="pacose.adalasso",cv.method="CV",adaptive=TRUE)
  setTxtProgressBar(pb, i/B)
}
close(pb)

pdf("figure6.pdf")
par(mgp=c(3,2,0))
layout(t(1:2))
boxplot(res.ridgeHKB1,ylim=c(0.4,1),names=c("Ridge","iPACOSE"),
        main="n=100 and p=50",cex.axis=1,cex.main=1)
boxplot(res.ridgeHKB2,ylim=c(0.4,1),names=c("Ridge","iPACOSE"),
        main="n=50 and p=100",cex.axis=1,cex.main=1)
dev.off()

pdf("figure7.pdf")
# (a) Ridge
par(mgp=c(3,2,0))
layout(t(1:2))
boxplot(res.ridge1,ylim=c(0.4,1),names=c("Ridge","iPACOSE"),
        main="n=100 and p=50",cex.axis=1,cex.main=1)
boxplot(res.ridge2,ylim=c(0.4,1),names=c("Ridge","iPACOSE"),
        main="n=50 and p=100",cex.axis=1,cex.main=1)
# (b) PLS
par(mgp=c(3,2,0))
layout(t(1:2))
boxplot(res.pls1,ylim=c(0.4,1),names=c("PLS","iPACOSE"),
        main="n=100 and p=50",cex.axis=1,cex.main=1)
boxplot(res.pls2,ylim=c(0.4,1),names=c("PLS","iPACOSE"),
        main="n=50 and p=100",cex.axis=1,cex.main=1)
# (c) LASSO
par(mgp=c(3,2,0))
layout(t(1:2))
boxplot(res.lasso1,ylim=c(0.4,1),names=c("Non adaptive LASSO","iPACOSE"),
        main="n=100 and p=50",cex.axis=1,cex.main=1)
boxplot(res.lasso2,ylim=c(0.4,1),names=c("Non adaptive LASSO","iPACOSE"),
        main="n=50 and p=100",cex.axis=1,cex.main=1)
# (d) Adaptive LASSO
par(mgp=c(3,2,0))
layout(t(1:2))
boxplot(res.adalasso1,ylim=c(0.4,1),names=c("Adaptive  LASSO","iPACOSE"),
        main="n=100 and p=50",cex.axis=1,cex.main=1)
boxplot(res.adalasso2,ylim=c(0.4,1),names=c("Adaptive  LASSO","iPACOSE"),
        main="n=50 and p=100",cex.axis=1,cex.main=1)
dev.off()
