### Compare the MSE of different covariance selection methods
comparisonMethods_final <- function(p, n, niter, plot=TRUE, returnRes=T, verbose=TRUE,
			methodNames=c("GeneNet","PACOSE(1)","PACOSE(2)","PACOSE(3)","PACOSE(4)","glasso","Wermuth","Whittaker","MVUE","SURE"),
      barabasi=TRUE,decomp=TRUE){

	## preliminaries
	mse_pcor <- matrix(NA,niter,10)
  proba <- 3/p
	resList<-list()
  pb <- txtProgressBar(style=3)
	for (b in 1:niter) {
  		if (decomp & barabasi) {
         gr <- barabasi.game(p, directed =FALSE)
         A1 <- get.adjacency(gr,type="upper")
         A1[A1 != 0] <- sample(c(-1,1),length(E(gr)),T)*runif(length(E(gr)),0.8,1)
         M2 <- cov2cor((diag(1,p)+A1)%*%t(diag(1,p)+A1) )
         gr <- graph.adjacency(0 + (M2!=0 & !diag(p)),mode="undirected")
         omega <- cov2cor(M2)
      } else if (decomp & !barabasi) {
         gr <- erdos.renyi.game(p, proba)
         A1 <- get.adjacency(gr,type="upper")
         A1[A1 != 0] <- sample(c(-1,1),length(E(gr)),T)*runif(length(E(gr)),0.8,1)
         M2 <- cov2cor((diag(1,p)+A1)%*%t(diag(1,p)+A1) )
         gr <- graph.adjacency(0 + (M2!=0 & !diag(p)),mode="undirected")
         omega <- cov2cor(M2)
         while(!isDecomposable(igraph.to.graphNEL(gr))) {
           gr <- erdos.renyi.game(p, proba)
           A1 <- get.adjacency(gr,type="upper")
           A1[A1 != 0] <- sample(c(-1,1),length(E(gr)),T)*runif(length(E(gr)),0.8,1)
           M2 <- cov2cor((diag(1,p)+A1)%*%t(diag(1,p)+A1) )
           gr <- graph.adjacency(0 + (M2!=0 & !diag(p)),mode="undirected")
           omega <- cov2cor(M2)
         }
         #print(gr)
      } else {
        gr <- erdos.renyi.game(p, proba)
        A1 <- get.adjacency(gr,type="upper")
        A1[A1 != 0] <- sample(c(-1,1),length(E(gr)),T)*runif(length(E(gr)),0.8,1)
        M2 <- cov2cor((diag(1,p)+A1)%*%t(diag(1,p)+A1) )
        gr <- graph.adjacency(0 + (M2!=0 & !diag(p)),mode="undirected")
        omega <- cov2cor(M2)
        while(isDecomposable(igraph.to.graphNEL(gr))) {
           gr <- erdos.renyi.game(p, proba)
           A1 <- get.adjacency(gr,type="upper")
           A1[A1 != 0] <- sample(c(-1,1),length(E(gr)),T)*runif(length(E(gr)),0.8,1)
           M2 <- cov2cor((diag(1,p)+A1)%*%t(diag(1,p)+A1) )
           gr <- graph.adjacency(0 + (M2!=0 & !diag(p)),mode="undirected")
           omega <- cov2cor(M2)
        }
        
      }
      mu <- rnorm(p)
      # A simpler model for the inverse covariance matrix
  		# would be : omega <- graph.laplacian(gr) + 1*diag(1,p,p)
  		sigma <- solve(omega)
		  # random data generation
  		x <- rmvnorm(n=n,mu,sigma)

  		# Strimmer method to estimate the precision matrix
      pcorShrink <- pcor.shrink(x,verbose=FALSE)

      # Ridge PACOSE
  		pcor2.1 <- pacose.ridge(x,gr,k=10,cv.method="CV")$pcor
      # PLS PACOSE
  		pcor2.2 <- pacose.pls(x,gr,k=10)$pcor
      # (ada)LASSO PACOSE
  		tmp <- pacose.adalasso(x,gr,k=10)
      pcor2.3 <- tmp$pcor.lasso
      pcor2.4 <- tmp$pcor.adalasso
      # glasso
  		kglasso <- glasso(cov(x),0.1,zero=get.edgelist(graph.complementer(gr)))$wi

      # Wermuth
  		omegahat <- INVEST_wrapper(x,get.edgelist(graph.complementer(gr, loops=FALSE)),delta=1e-20,itermax=1000)
  		
      # Whittaker
  		nam <- paste("V",1:p,sep="")
  		adja <- get.adjacency(gr) ; S <- cov(x)
      rownames(adja) <- colnames(adja) <- rownames(S) <- colnames(S) <- nam
      cliqlist <- lapply(rip(igraph.to.graphNEL(gr))$cliques,function(v) nam[as.numeric(v)+1])
      if (length(cliqlist)==0) {
        omggm <- matrix(NaN,p,p)
      } else {
        omggm <- pseudoinverse(fitConGraph(adja, S , n = n,cli=cliqlist)$Shat)
      }
      # MVUE
      KhatMVUE <- omegaMVUE(x,gr)
		  # SURE
  		KhatSURE <- omegaSURE(x,gr)

		  ##resulting partial correlation matrices
 		  result_pcor <- list(Srimmer=pcorShrink,P1=pcor2.1,P2=pcor2.2,P3=pcor2.3,P4=pcor2.4,
                         glasso=invcov2pcor(kglasso),Wermuth=invcov2pcor(omegahat$invcov),
                         Whittaker=invcov2pcor(omggm),MVUE=invcov2pcor(KhatMVUE),SURE=invcov2pcor(KhatSURE))
      
      mse_pcor[b,] <- sapply(result_pcor,function(mat) if(is.null(mat)) { NA } else { mean((mat - invcov2pcor(omega) )**2) } )
      


		  ## one list entry for each iteration
		  resList[[b]]<-list( p=p, n=n, graph = gr, omega=omega, x=x, result_pcor=result_pcor)
		  if (verbose) setTxtProgressBar(pb,b/niter)
	}
	close(pb)


	if(returnRes) return(resList)
}