# Run iPACOSE on a simulated dataset
newgraphestimation <- function(p=25, n=25, k=k, niter=100, cutoffs = c(0.05,0.1,0.2,0.3),method1="ridge.net",method2="pacose.ridge",adaptive=FALSE) {

  mu <- rnorm(p)

  foo_sen <- function(gg) nbri(gr,gg)/nbr(gr)
  foo_ppv <- function(gg) nbri(gr,gg)/nbr(gg)

  cof <- rep(NA,niter)
  res <- matrix(NA,niter,5)
  pb <- txtProgressBar(style=3)
  sens   <- ppv   <- matrix(NA,niter,length(cutoffs)+1)
  sens_0 <- ppv_0 <- matrix(NA,niter,length(cutoffs))

  for (i in 1:niter) {
    gr <- erdos.renyi.game(p,4/p)

    # simple model for the inverse covariance matrix
    A <- get.adjacency(gr,type="upper")
    A[A != 0] <- sample(c(-1,1),length(E(gr)),T)*runif(length(E(gr)),0.8,1)
    omega <- (diag(1,p)+A)%*%t(diag(1,p)+A)
    gr <- graph.adjacency(0 + (omega!=0 & !diag(p)),mode="undirected")
    sigma <- solve(omega)
    # random data generation
    x <- rmvnorm(n=n,mu,sigma)

    if (method1=="ridge.net") {
      res1 <-  do.call(method1,list(X=x,k=k,verbose=F,cv.method="CV"))
    } else {
      res1 <-  do.call(method1,list(X=x,k=k,verbose=F))
    }
    if ( (method1 == "adalasso.net") & (!adaptive) ) {
      pc <- res1$pcor.lasso
    }else if ( (method1 == "adalasso.net") & (adaptive) )  {
      pc <- res1$pcor.adalasso
    } else {
      pc <- res1$pcor
    }

    cof[i] <- fdrtool(pc[upper.tri(pc)], statistic = "correlation", plot = F,verbose=F)$param[1]
    res_it <- ipacose(x,pc,method=method2,cof[i],gr,k=k,cv.method="CV")
    sens[i,1] <- res_it$sens
    ppv[i,1]  <- res_it$ppv


    for (j in 1:length(cutoffs)+1) {
      res_it <- ipacose(x,pc,method=method2,cutoffs[j-1],gr,k=k,cv.method="CV")
      sens[i,j] <- res_it$sens
      ppv[i,j]  <- res_it$ppv
    }

    sens_0[i,] <- sapply(cutoffs,function(z) foo_sen( graph.adjacency((abs(pc) >= z) - diag(p),mode="undirected") )  )
    ppv_0[i,]  <- sapply(cutoffs,function(z) foo_ppv( graph.adjacency((abs(pc) >= z) - diag(p),mode="undirected") )  )

    setTxtProgressBar(pb,i/niter)
  }
  close(pb)


  sens_m <- apply(sens[,-1],2,function(vec) ifelse(all(is.na(vec)),0,mean(vec[!is.na(vec)])) )
  ppv_m  <- apply(ppv[,-1],2,function(vec) ifelse(all(is.na(vec)),0,mean(vec[!is.na(vec)])) )
  sens_0m <- apply(sens_0,2,function(vec) ifelse(all(is.na(vec)),0,mean(vec[!is.na(vec)])) )
  ppv_0m  <- apply(ppv_0,2,function(vec) ifelse(all(is.na(vec)),0,mean(vec[!is.na(vec)])) )

  reslist <- list(sens_m=sens_m,ppv_m=ppv_m,sens_0m=sens_0m,ppv_0m=ppv_0m)
  return(reslist)
}
