# Evaluate the stability of the graphs estimated with iPACOSE
stability_simulations <- function(p=25,n=50, nfold=3, k=2, method1="ridge.net",method2="pacose.ridge",cv.method="HKB",adaptive=FALSE) {
  gr0 <- erdos.renyi.game(p, 3/p)
  A1 <- get.adjacency(gr0,type="upper")
  A1[A1 != 0] <- sample(c(-1,1),length(E(gr0)),T)*runif(length(E(gr0)),0.8,1)
  M2 <- cov2cor((diag(1,p)+A1)%*%t(diag(1,p)+A1) )
  gr <- graph.adjacency(0 + (M2!=0 & !diag(p)),mode="undirected")
  omega <- cov2cor(M2)
  mu <- rnorm(p)
  sigma <- solve(omega)
  # random data generation
  x <- rmvnorm(n=n,mu,sigma)
  folds <- split(sample(1:n), rep(1:nfold, length = n))
  pcor <- matrix(NA,nfold,p*(p-1)/2)
  pacose <- matrix(NA,nfold,p*(p-1)/2)
  
  for (j in 1:nfold) {
    #cat("Fold", j, ":")
    index  <- folds[[j]]
    if (method1=="ridge.net") {
      res1 <-  do.call(method1,list(X=x[-index,],k=k,verbose=F,cv.method=cv.method))
    } else {
      res1 <-  do.call(method1,list(X=x[-index,],k=k,verbose=F))
    }
    if ( (method1 == "adalasso.net") & (!adaptive) ) {
      temp <- res1$pcor.lasso
    }else if ( (method1 == "adalasso.net") & (adaptive) )  {
      temp <- res1$pcor.adalasso
    } else {
      temp <- res1$pcor
    }
    cutoff <- fdrtool(temp[upper.tri(temp)], statistic = "correlation", plot = F,verbose=F)$param[1]
    temp[abs(temp) < cutoff] <- 0
    pcor[j,] <- aa <- temp[upper.tri(temp)]
    temp2 <- ipacose(x[-index,],pc=temp,method=method2,cutoff=cutoff,gr=NULL,k=k, cv.method=cv.method,adaptive=adaptive)$pcor_it
    pacose[j,] <- bb <- temp2[upper.tri(temp2)]
    aa <- abs(aa) ; bb <- abs(bb)
    pcor[j, order(aa)[1:sum(bb==0)] ]  <- 0
  }
  return(c(ridge.net = kappam.fleiss(t(pcor  !=0)+0)$value,
    iPACOSE   = kappam.fleiss(t(pacose!=0)+0)$value)       )
}
