################################################################################
# Modified functions of the R package SHIP. 'Modified' means that the SHIP     #
# functions are adapted to the two-class case in order to be applicable in the #
# framework of two-class LDA.                                                  #
################################################################################


#####################
# 1. build.target() #
#####################

build.target <- function(x,y,genegroups=NULL,type) {

                targetFun  <- switch(type, cor = targetCor,
                              D = targetD,
                              F = targetF,
                              G = targetG,
                              Gpos = targetGpos,
                              Gstar= targetGstar)
                res        <- targetFun(x,y,genegroups)
                }


###################
# 2. check.path() #
###################

check.path <- function(p1,p2) {
              if ( !all(is.na(p1)) & !all(is.na(p2)) ) {
              for (i in 1:length(p1)) { if (p1[i] %in% p2) { return(1) } }
               }
              return(0)
              }


####################
# 3. target.help() #
####################

target.help <- function(genes) {
               T <- diag(1,length(genes))
               for (i in 2:length(genes)) {
               for(j in 1:(i-1)) {
               T[j,i] <- T[i,j] <- check.path(genes[[i]],genes[[j]])
                 }
                }
               return(T)
               }


################
# 4. targetD() #
################

targetD <- function(x,y,genegroups) diag(centroids(x,y,verbose=FALSE)$var.pooled)                          


##############
# 5. targetG #
##############

targetG <- function(x,y,genegroups) {
           T1   <- target.help(genegroups)
           T2   <- matrix(nrow=length(genegroups),ncol=length(genegroups),data=0)
           corm <- T1*centroids(x,y,verbose=FALSE,powcor.pooled=TRUE)$powcor.pooled
           diag(corm)<- 0
           cora <- sum(colSums(corm))/sum(corm!=0)
           varp <- centroids(x,y,verbose=FALSE)$var.pooled
           names(varp) <- NULL
           for (i in 1:length(genegroups)) {
             for (j in 1:i) {
             if (i!=j & T1[i,j]==1) T2[i,j] <- cora*(sqrt(varp[i])*sqrt(varp[j]))     
             if (i==j) T2[i,j] <- varp[i]
             T2[j,i] <- T2[i,j]
               }
              }
             T2
           }
           
           
##################
# 6. targetGpos  #
##################

targetGpos <- function(x,y,genegroups) {
              T1   <- target.help(genegroups)
              T2   <- matrix(nrow=length(genegroups),ncol=length(genegroups),data=0)
              corm <- T1*centroids(x,y,verbose=FALSE,powcor.pooled=TRUE)$powcor.pooled
              diag(corm) <-0
              sum.pos    <- sum(corm[T1==1 & corm > 0])
              cora.pos   <- ifelse(sum(corm>0)==0,0,sum.pos/sum(corm>0))
              varp <- centroids(x,y,verbose=FALSE)$var.pooled
              names(varp) <- NULL
              for (i in 1:length(genegroups)) {
                for (j in 1:i) {
                if (i!=j & T1[i,j]==1) T2[i,j] <- cora.pos*(sqrt(varp[i])*sqrt(varp[j]))
                if (i==j) T2[i,j] <- varp[i]
                T2[j,i]<-T2[i,j]
                  }
                 }
                T2
              }

              
###################
# 7. targetGstar  #
###################

targetGstar <- function(x,y,genegroups) {
               T1   <- target.help(genegroups)
               T2   <- matrix(nrow=length(genegroups),ncol=length(genegroups),data=0)
               corm <- T1*centroids(x,y,verbose=FALSE,powcor.pooled=TRUE)$powcor.pooled
               diag(corm)<- 0
               sum.pos   <- sum(corm[T1==1 & corm > 0])
               sum.neg   <- sum(corm[T1==1 & corm < 0])

               cora.pos  <- sum.pos/sum(corm>0)
               cora.neg  <- sum.neg/sum(corm<0)

               varp <- centroids(x,y,verbose=FALSE)$var.pooled
               names(varp) <- NULL
              
               for (i in 1:length(genegroups)) {
               for (j in 1:i) {
               if (i!=j & T1[i,j]==1 & corm[i,j] > 0) T2[i,j] <- cora.pos*(sqrt(varp[i])*sqrt(varp[j]))
               if (i!=j & T1[i,j]==1 & corm[i,j] < 0) T2[i,j] <- cora.neg*(sqrt(varp[i])*sqrt(varp[j]))
               if (i==j) T2[i,j] <- varp[i]
               T2[j,i] <- T2[i,j]
                  }
                 }
               T2
               }
               
               
##############
# 8. targetF #
##############

targetF <- function(x,y,genegroups) {

           p <- ncol(x) ; n <- nrow(x)
           y <- as.factor(y)
           levels(y) <- 1:nlevels(y)
           if(nlevels(y) > 2)
           stop("The method is created for binary outcomes only. \n")
           y <- as.numeric(y)-1
       
           x0 <- x[y==0,]
           x1 <- x[y==1,]                                      
           x0 <- scale(x0,center=TRUE,scale=FALSE)                                     
           x1 <- scale(x1,center=TRUE,scale=FALSE)                                    
           covm <- (1/(n-2))*((nrow(x0)-1)*cov(x0) + (nrow(x1)-1)*cov(x1))
           corm <- cov2cor(covm)
           var.only   <- covm/corm
           diag(corm) <- 0
           cora       <- sum(corm)/sum(corm!=0)
           T          <- cora*var.only
           diag(T)    <- diag(covm)
           T
           }


#################
# 9. targetCor  #
#################

targetCor <- function(x,y,genegroups) {

             T1 <- target.help(genegroups)
             T2 <- matrix(nrow=length(genegroups),ncol=length(genegroups),data=0)

             y <- as.factor(y)
             levels(y) <- 1:nlevels(y)
             if(nlevels(y) > 2)
             stop("The method is created for binary outcomes only. \n")
             y <- as.numeric(y)-1
       
             x0 <- x[y==0,]
             x1 <- x[y==1,]                                      
             x0 <- scale(x0,center=TRUE,scale=FALSE)                                     
             x1 <- scale(x1,center=TRUE,scale=FALSE)
             xs <- rbind(x0,x1)
             for (i in 2:length(genegroups)) {
             for (j in 1:(i-1)) if (T1[i,j]==1) T1[i,j] <- ifelse(cor.test(xs[,i],xs[,j])$p.value < 0.05,1,0)
             }

             corm <- T1*centroids(x,y,verbose=FALSE,powcor.pooled=TRUE)$powcor.pooled
             diag(corm) <- 0

             cora <- ifelse(sum(corm!=0)==0,0,sum(colSums(corm))/sum(corm!=0))

             varp <- centroids(x,y,verbose=FALSE)$var.pooled
             names(varp) <- NULL
               
             for (i in 1:length(genegroups)) {
             for (j in 1:i) {
             if (i!=j & T1[i,j]==1) T2[i,j] <- cora*(sqrt(varp[i])*sqrt(varp[j]))
             if (i==j) T2[i,j] <- varp[i]
             T2[j,i] <- T2[i,j]
                }
               }
             T2
             }


#########################
# 10. shrink.estim.pool #
#########################

shrink.estim.pool <- function(x,y,tar) {                                        
# 'y' must be a factor with two levels indicating the class membership.
                                                    
    if (is.matrix(x)==TRUE && is.numeric(x)==FALSE) stop("The data matrix must be numeric!")

    p <- ncol(x) ; n <- nrow(x)
    
    y <- as.factor(y)
    levels(y) <- 1:nlevels(y)
    if(nlevels(y) > 2)
    stop("The method is created for binary outcomes only. \n")
    y <- as.numeric(y)-1
       
    x0 <- x[y==0,]
    x1 <- x[y==1,]                                      
    # Standardization of the data matrix that is necessary when only 
    # the correlations are to be shrunken. 
    x0 <- scale(x0,center=TRUE,scale=FALSE)                                     
    x1 <- scale(x1,center=TRUE,scale=FALSE)                                     
    xs <- rbind(x0,x1)
    covm <- (1/(n-2))*((nrow(x0)-1)*cov(x0) + (nrow(x1)-1)*cov(x1))             
    # Varianzen der zentrierten (!) Matrix bilden.
    corm <- cor(xs)
    xs   <- scale(xs,center=TRUE,scale=TRUE)
    
    v <- (n/((n-1)^3))*(crossprod(xs^2) - 1/n*(crossprod(xs))^2)
    diag(v) <- 0
    
    m <- matrix(rep(apply(xs**2,2,mean),p),p,p)
    f <- (n/(2*(n-1)^3))*(crossprod(xs**3,xs) + crossprod(xs,xs**3) - (m+t(m))*crossprod(xs))
    diag(f) <- 0 ; f[tar == 0] <- 0
    
    corapn <- cov2cor(tar)
    d      <- (corm - corapn)^2
    lambda <- (sum(v)- sum(corapn*f))/sum(d)
    lambda <- max(min(lambda, 1), 0)
    shrink.cov <- lambda*tar+(1-lambda)*covm

    return(list(shrink.cov, c("The shrinkage intensity lambda is:",round(lambda,digits=4))))
}

