# The modified version of the RGCCA program allowing the integration of 
# a prior on groups of variables into the estimation of the blocks' covariance matrices.

rgcca2 <- function (A, C, tau = "optimal", scheme = "centroid", scale = TRUE,
    layout = FALSE,target=NULL,plot=FALSE) {
    nbloc = length(A)
    if (is.null(target)) target <- lapply(A,function(a) diag(1,ncol(a)))
    if (scale == TRUE) {
        A = lapply(A, myscale)
    }
    if (!is.numeric(tau)) {
        if(plot) print("Optimal Shrinkage intensity paramaters are estimated")
        # tau = unlist(lapply(A, tau.estimate))
        # tau = unlist( lapply(A,function(a) shrink.estim2(a)$lambda) )
        tau <- sapply(1:nbloc, function(ii) shrink.estim2(A[[ii]],tar=target[[ii]])$lambda )
        #print(tau)
        tau[4] = 0
        if(plot) print(tau)
    }
    else {
        if (is.numeric(tau)) {
            if(plot) print("Shrinkage intensity paramaters are chosen manually")
        }
    }
    a = list()
    for (q in 1:nbloc) a[[q]] = rnorm(ncol(A[[q]]))
    M = list()
    Y = matrix(0, nrow(A[[1]]), nbloc)
    for (q in 1:nbloc) {
        M[[q]] = solve(tau[q] * target[[q]] + ((1 - tau[q])/nrow(A[[q]])) *
            (t(A[[q]]) %*% A[[q]]))
        a[[q]] = as.vector(1/sqrt(t(a[[q]]) %*% M[[q]] %*% a[[q]])) *
            M[[q]] %*% a[[q]]
        Y[, q] = A[[q]] %*% a[[q]]
    }
    iter = 1
    crit = numeric(300)
    converg = numeric(300)
    Z = matrix(0, nrow(A[[1]]), nbloc)
    AVE_X = numeric()
    if ((scheme != "horst") & (scheme != "factorial") & (scheme !=
        "centroid")) {
        cat("ERROR : choose one of the three following schemes : horst, centroid or factorial")
    }
    else {
        if (scheme == "horst") {
            if(plot) print("Computation of the PLS components based on the Horst scheme")
        }
        if (scheme == "factorial") {
            if(plot) print("Computation of the PLS components based on the Factorial scheme")
        }
        if (scheme == "centroid") {
            if(plot) print("Computation of the PLS components based on the Centroid scheme")
        }
        repeat {
            Yold = Y
            if (scheme == "horst") {
                for (q in 1:nbloc) {
                  Z[, q] = rowSums(matrix(rep(C[q, ], nrow(A[[q]])),
                    nrow(A[[q]]), nbloc, byrow = TRUE) * Y)
                  a[[q]] = as.vector(1/sqrt(t(Z[, q]) %*% A[[q]] %*%
                    M[[q]] %*% t(A[[q]]) %*% Z[, q])) * (M[[q]] %*%
                    t(A[[q]]) %*% Z[, q])
                  Y[, q] = A[[q]] %*% a[[q]]
                }
            }
            if (scheme == "factorial") {
                for (q in 1:nbloc) {
                  Z[, q] = rowSums(matrix(rep(C[q, ], nrow(A[[q]])),
                    nrow(A[[q]]), nbloc, byrow = TRUE) * matrix(rep(mycov(Y[,
                    q], Y), nrow(A[[q]])), nrow(A[[q]]), nbloc,
                    byrow = TRUE) * Y)
                  a[[q]] = as.vector(1/sqrt(t(Z[, q]) %*% A[[q]] %*%
                    M[[q]] %*% t(A[[q]]) %*% Z[, q])) * (M[[q]] %*%
                    t(A[[q]]) %*% Z[, q])
                  Y[, q] = A[[q]] %*% a[[q]]
                }
            }
            if (scheme == "centroid") {
                for (q in 1:nbloc) {
                  Z[, q] = rowSums(matrix(rep(C[q, ], nrow(A[[q]])),
                    nrow(A[[q]]), nbloc, byrow = TRUE) * sign(matrix(rep(mycov(Y[,
                    q], Y), nrow(A[[q]])), nrow(A[[q]]), nbloc,
                    byrow = TRUE)) * Y)
                  a[[q]] = as.vector(1/sqrt(t(Z[, q]) %*% A[[q]] %*%
                    M[[q]] %*% t(A[[q]]) %*% Z[, q])) * (M[[q]] %*%
                    t(A[[q]]) %*% Z[, q])
                  Y[, q] = A[[q]] %*% a[[q]]
                }
            }
            num_converg <- sum((rowSums(Yold) - rowSums(Y))^2)
            den_converg <- sum(rowSums(Yold)^2)
            converg[iter] <- num_converg/den_converg
            if (scheme == "horst") {
                crit[iter] = sum(C * mycov(Y))
            }
            if (scheme == "factorial") {
                crit[iter] = sum((C * mycov(Y)^2))
            }
            if (scheme == "centroid") {
                crit[iter] = sum(C * abs(mycov(Y)))
            }
            if ( (converg[iter] < .Machine$double.eps) | (iter > 200) ) break
            iter = iter + 1
        }
        if (layout == TRUE) {
            plot(1:length(which(crit != 0)), log(crit[which(crit !=
                0)]), xlab = "iteration", ylab = "criteria")
            x11()
            pairs(Y, labels = paste("Y", 1:ncol(Y)))
        }
        lambda = numeric(nbloc)
        for (q in 1:nbloc) {
            lambda[q] = mycov(Y[, q], Z[, q])
            AVE_X[q] = mean(cor(A[[q]], Y[, q])^2)
        }
        AVEouter = sum((unlist(lapply(A, function(x) ncol(x))) * AVE_X))/sum(unlist(lapply(A, function(x) ncol(x))))
        AVEinner = sum(C * cor(Y)^2/2)/(sum(C)/2)
        AVEglobal = sqrt(AVEouter * AVEinner)
        AVE = list(AVE_per_block = AVE_X, AVE_outer_model = AVEouter,
            AVE_inner_model = AVEinner, Global_AVE = AVEglobal)
        result = list(Y = Y, Z = Z, a = a, crit = crit[which(crit !=
            0)], converg = converg[which(converg != 0)], lambda = lambda,
            AVE = AVE, C = C, tau = tau, scheme)
        return(result)
    }
}