# Data to which RGCCA can be applied should be structured into blocks.
# This function aims at simulating such blocks of Gaussian variables,
# each block itself being structured into groups of variables.

simulateRGCCA <- function(k=3,noise=TRUE,invcov=FALSE,alpha=1,n=50){
  p1 <- 100 ; p2 <- 200 ; p3 <- 50 ; p <- sum(p1,p2,p3)
  sigmaComponents <- matrix(c(1,0.7,0.7,0.7,1,0,0.7,0,1),3,3)
  etaks <- rmvnorm(n=n,sigma=sigmaComponents)
  alphas1 <- rep(alpha,p1)
  alphas2 <- rep(alpha,p2)
  alphas3 <- rep(alpha,p3)
  genegroups <- NULL
  
  o1 <- simulate(mus=list(rep(0,p1)),nn=n,pks=c(20,20,20,20,20),aks=c(0.8,0.9,0.7,0.85,0.96),noise=noise,invcov=invcov)
  z1 <- o1$X ; genegroups[[1]] <- o1$genegroups
  o2 <- simulate(mus=list(rep(0,p2)),nn=n,pks=c(100,100)       ,aks=c(0.8,0.9)      ,noise=noise,invcov=invcov)
  z2 <- o2$X ; genegroups[[2]] <- o2$genegroups
  o3 <- simulate(mus=list(rep(0,p3)),nn=n,pks=c(20,20,10)      ,aks=c(0.8,0.9,0.85)    ,noise=noise,invcov=invcov)
  z3 <- o3$X ; genegroups[[3]] <- o3$genegroups
  x1 <- etaks[,1]%*%t(alphas1) + z1
  x2 <- etaks[,2]%*%t(alphas2) + z2
  x3 <- etaks[,3]%*%t(alphas3) + z3
   
  C <- matrix(c(0,1,1,1,0,0,1,0,0),3,3)
  return(list(Xlist=list(X1=x1,X2=x2,X3=x3),C=C,sigmaComponents=sigmaComponents,etaks=etaks,genegroups=genegroups))
}