# Generate a matrix with 1 on the diagonal and off diagonal coefficients
# all equal to ak
block <- function(size,ak) {
  mat <- matrix(ak,size,size)
  diag(mat) <- 1
  if (! is.positive.definite(mat) ) mat <- make.positive.definite(mat)
  mat
}

# Generate a covariance matrix strutured into groups of variables
matcov <- function(pks=c(10,10),aks=c(0.5,0.5),noise=FALSE) {
  K <- length(pks)
  mat <- matrix(0,sum(pks),sum(pks))  
  ak1 <- cumsum(c(1,pks))[-(K+1)]  
  ak2 <- cumsum(c(0,pks))[-1]  
  if (noise) {
    for(k in 1:K) mat[ak1[k]:ak2[k],ak1[k]:ak2[k]] <- matrix(sample(c(-1,1),pks[k],T)*rnorm(pks[k]**2, aks[k], 0.2),pks[k]) 
    mat <- mat %*% t(mat) 
  } else {
    for(k in 1:K) mat[ak1[k]:ak2[k],ak1[k]:ak2[k]] <- block(pks[k],ak=aks[k]) 
  }
  if (! is.positive.definite(mat) ) mat <- make.positive.definite(mat)
  mat
}
