# Simulate Gaussian multivariate samples with covariance matrix structured into groups of variables
simulate <- function(mus=list(rep(0,20),rnorm(20)),nn=c(20,20),pks=c(10,10),aks=c(0.9,0.9),noise=FALSE,invcov=FALSE) {
  if (invcov) {sigma <- solve(matcov(pks,aks,noise))
  } else {sigma <- matcov(pks,aks,noise)}
  xlist <- lapply(1:length(nn),function(ii) rmvnorm(nn[ii],mus[[ii]],sigma) )
  x     <- do.call("rbind",xlist)
  permut <- sample(1:sum(pks))
  x <- x[,permut] ; genegroups <- as.list(rep(1:length(pks),pks)[permut])
  return(list(X=x,y=rep(1:length(nn),nn),genegroups=genegroups))
}

