###################
# 3. GlobalANCOVA #
###################

rm(list=ls())

############################################################
## Enter below the name of your working directory          #
## This is the only thing to change to obtain the figures  #
## presented in the article                                #
############################################################         
wd <- "~/reproducibleCode"

# load libraries        
require(mvtnorm)
require(SHIP)
require(corpcor)

# source necessary functions
setwd(wd)
source("SimulatedData/simulate.R")
source("SimulatedData/fonc.R")
source("GlobalAncova/ga2.R")
source("GlobalAncova/approximation.R")
source("GlobalAncova/shrink.estim2.R")

# Parameters of the simulation as specified in the article
niter <- 1000
pks <- sample(rep(2:4,c(34,30,18))); p <- sum(pks)
aks <- sample(rep(c(0.8,0.85,0.9,0.95),e=50))
nbgene <- min(30,p)
nn=c(50,50)

pb <- txtProgressBar(style=3)
resmat <- matrix(NA,niter,3)
for (i in 1:niter) {
  mu1 <- mu2 <- rnorm(p)
  o <- simulate(mus=list(mu1,mu2),nn=nn,pks=pks,aks=aks,noise=FALSE)
  gr <- o$y
  group.name   <- deparse(substitute(gr))
  res          <- group2formula(group=gr, group.name=group.name, covars=NULL, covar.names)
  resmat[i,1] <- expr.test(xx=t(o$X),formula.full=res$formula.full,formula.red=res$formula.red,
                model.dat=res$model.dat,method="approx",max.group.size=2500,eps=1e-16,
                acc=50,tar="D",genegroups=o$genegroups)$test.result[2]
  resmat[i,2] <- expr.test(xx=t(o$X),formula.full=res$formula.full,formula.red=res$formula.red,
                model.dat=res$model.dat,method="approx",max.group.size=2500,eps=1e-16,
                acc=50,tar="G",genegroups=o$genegroups)$test.result[2]
  resmat[i,3] <- expr.test(xx=t(o$X),formula.full=res$formula.full,formula.red=res$formula.red,
                model.dat=res$model.dat,method="approx",max.group.size=2500,eps=1e-16,
                acc=50,tar="G",genegroups=sample(o$genegroups))$test.result[2]
  setTxtProgressBar(pb,i/niter)
}
close(pb)

pdf("figure3.pdf",width=15,height=5)
layout(t(1:3))
par(cex=1.5)
hist(resmat[,1],main="Target D" ,xlab="p-values",freq=FALSE)
hist(resmat[,2],main="Target G",xlab="p-values",freq=FALSE)
hist(resmat[,3],main="Target G (p)",xlab="p-values",freq=FALSE)
dev.off()

ks.test(resmat[,1],punif,0,1)
ks.test(resmat[,2],punif,0,1)
ks.test(resmat[,3],punif,0,1)

save.image(file=paste(c("SaveGlobalANCOVA",gsub(":","_",as.character(Sys.time())),".RData"),sep="",collapse="_"))