############
# 2. RGCCA #
############

rm(list=ls())

############################################################
## Enter below the name of your working directory          #
## This is the only thing to change to obtain the figures  #
## presented in the article                                #
############################################################         
wd <- "~/reproducibleCode"

# load libraries        
require(Matrix)
require(mvtnorm)
require(SHIP)
library(gdata)
library(corpcor)
library(lattice)
library(entropy)
library(fdrtool)
library(sda)
require(RGCCA)

# source necessary functions
setwd(wd)
source("SimulatedData/simulate.R")
source("SimulatedData/fonc.R")
source("RGCCA/rgcca2.R")
source("RGCCA/targetRGCCA.R")
source('RGCCA/shrink.estim2.R')
source('RGCCA/simulateRGCCA.R')

# Parameters of the simulation as specified in the article
comp <- function(A,B) mean((abs(A)-abs(B))**2)
nn  <- list(50,200)
als <- list(0.1,sqrt(2))
tmpind <- expand.grid(1:length(nn),1:length(als))
params <- apply(tmpind,1,function(ii) list(n=nn[[ii[1]]],alpha=als[[ii[2]]]))
niter <- 100
for (j in 1:length(params)) assign(paste("res",j,sep=""),matrix(NA,niter,2)) 
for (j in 1:length(params)) assign(paste("reslambda",j,sep=""),matrix(NA,niter,2)) 
k <- 3
fooD  <- function(ii,o) shrink.estim2(o$X[[ii]],tar=targetD(o$X[[ii]],genegroups=NULL))$lambda
fooH1 <- function(ii,o) shrink.estim2(o$X[[ii]],tar=targetH(o$X[[ii]],genegroups=o$genegroups[[ii]]))$lambda
fooH2 <- function(ii,o) shrink.estim2(o$X[[ii]],tar=targetH(o$X[[ii]],genegroups=sample(o$genegroups[[ii]])))$lambda
for (j in 1:length(params)){
 restemp <- matrix(NA,niter,3)
 restemplambda <- matrix(NA,niter,3)
 pb <- txtProgressBar(1,niter,style=3)
 for (i in 1:niter) {
  setTxtProgressBar(pb, i)
  o <- simulateRGCCA(k,noise=FALSE,invcov=FALSE,alpha=params[[j]]$alpha,n=params[[j]]$n)
  X <- o$Xlist
  out1 <- rgcca2(X,o$C, tau = "optimal", scheme = "factorial")
  targethhpermut <- targethh <- vector("list",k)
  targethh[1:k] <- lapply(1:k,function(jj) (targetH(X[[jj]],o$genegroups[[jj]])) ) 
  targethhpermut[1:k] <- lapply(1:k,function(jj) (targetH(X[[jj]],sample(o$genegroups[[jj]]))) )  
  out2 <- rgcca2(X,o$C, scheme = "factorial",target=targethh)
  out3 <- rgcca2(X,o$C, scheme = "factorial",target=targethhpermut)
  restemp[i,1] <- comp(o$sigmaComponents,cor(out1$Y))
  restemp[i,2] <- comp(o$sigmaComponents,cor(out2$Y))
  restemp[i,3] <- comp(o$sigmaComponents,cor(out3$Y))
  restemplambda[i,1] <- mean(sapply(1:k,fooD,o))
  restemplambda[i,2] <- mean(sapply(1:k,fooH1,o))
  restemplambda[i,3] <- mean(sapply(1:k,fooH2,o))
 }
 assign(paste("res",j,sep=""),restemp)
 assign(paste("reslambda",j,sep=""),restemplambda)
 close(pb)
}

pdf("figure2.pdf",width=10,height=10)
layout(matrix(1:4,2,2))
par(cex=1.2)
boxplot(res1,names=c("D","H","H (p)"),main=expression(paste(n==50 ," and ",alpha == 0.1,sep="")),ylab="MSE",notch=TRUE)
boxplot(res2,names=c("D","H","H (p)"),main=expression(paste(n==200," and ",alpha == 0.1,sep="")),ylab="MSE",notch=TRUE)
boxplot(res3,names=c("D","H","H (p)"),main=expression(paste(n==50 ," and ",alpha == sqrt(2),sep="")),ylab="MSE",notch=TRUE)
boxplot(res4,names=c("D","H","H (p)"),main=expression(paste(n==200," and ",alpha == sqrt(2),sep="")),ylab="MSE",notch=TRUE)
dev.off()

pdf("supplementary_result_not_shown_for_lambda.pdf",width=10,height=10)
layout(matrix(1:4,2,2))
boxplot(reslambda1,names=c("D","H","H (p)"),main=expression(paste(n==50 ," and ",alpha == 0.1,sep="")),ylab=expression(lambda))
boxplot(reslambda2,names=c("D","H","H (p)"),main=expression(paste(n==200," and ",alpha == 0.1,sep="")),ylab=expression(lambda))
boxplot(reslambda3,names=c("D","H","H (p)"),main=expression(paste(n==50 ," and ",alpha == sqrt(2),sep="")),ylab=expression(lambda))
boxplot(reslambda4,names=c("D","H","H (p)"),main=expression(paste(n==200," and ",alpha == sqrt(2),sep="")),ylab=expression(lambda))
dev.off()

save.image(file=paste(c("SaveRGCCA",gsub(":","_",as.character(Sys.time())),".RData"),sep="",collapse="_"))
