# Number of CPUs to use:

ncpus <- 18

# Make scenario grid:

scenariogrid <- expand.grid(batchlearnind=1:2, 
  batchremmethod=c("none", "fabatch", "combat", "fsvafast", "fsvaexact", "meancenter", 
  "standardize", "ratioa", "ratiog"))
  

# Use the same seed when applying the different methods:

set.seed(1234)
seeds <- sample(1000:10000000, size=2)
scenariogrid$seed <- sapply(scenariogrid$batchlearnind, function(x) seeds[x])


# Source functions for performing the analysis on the cluster:

source("./FAbatchPaper/Functions/RealdataanalysisSnowfallFunctions.R")


# Load 'snowfall'-Package for parallel computation:
require("snowfall")


# Initiate cluster:
sfInit(parallel=TRUE, cpus=ncpus, type = "MPI")

# Export all objects to the CPUs:
sfExportAll()

# Perform cross-batch prediction with batch effect removal:
CrossbatchpredResults <- sfLapply(1:nrow(scenariogrid), function(z) performCrossBatchPrediction(z))

# Stop the cluster:
sfStop()

# Save results:
save(CrossbatchpredResults, file="./FAbatchPaper/Results/CrossbatchpredResults.Rda")

# Clear the workspace:
rm(list=ls())
