# Number of CPUs to use:

ncpus <- 60


# Used data sets:

datasets <- c("AgeDichotomTranscr", "AlcoholismTranscr", "AutismTranscr", 
  "BipolardisorderMethyl", "BreastCancerConcatenation", "BreastcTranscr", 
  "ColonGastricEsophagealcSNPArray",
  "EthnicityMethyl", "IBSTranscr", "IUGRTranscr",
  "PostpartumDepressionMethyl", "pSSTranscr", "SarcoidosisTranscr", "WestNileVirusTranscr")


# Different seed for each dataset:
  
set.seed(1234)
seeds <- sample(1000:10000000, size=length(datasets))


# Make scenario grid for batch effect removal:

batchremovalgrid <- expand.grid(batchremmethod=c("none", "fabatch", "combat", "sva", "meancenter", 
  "standardize", "ratioa", "ratiog"), dataset=datasets, stringsAsFactors = FALSE)
batchremovalgrid <- batchremovalgrid[,ncol(batchremovalgrid):1]
batchremovalgrid$seed <- sapply(batchremovalgrid$dataset, function(x) seeds[datasets==x])
batchremovalgrid$datasetbrind <- 1:nrow(batchremovalgrid)
nbatchremoval <- nrow(batchremovalgrid)


# Make scenario grid for applying different metrics:

metricgrid <- expand.grid(metric=c("sep", "avedist", "kldist", "skew", "pvca", 
  "diffexpr", "cor"), datasetbrind=batchremovalgrid$datasetbrind, stringsAsFactors = FALSE)
metricgrid <- metricgrid[,ncol(metricgrid):1]
nmetric <- nrow(metricgrid)


# Source functions for performing the analysis on the cluster:

source("./FAbatchPaper/Functions/RealdataanalysisSnowfallFunctions.R")


# Load 'snowfall'-Package for parallel computation:
require("snowfall")


# Initiate cluster:
sfInit(parallel=TRUE, cpus=ncpus, type = "MPI")

# Export all objects to the CPUs:
sfExportAll()

# Perform batch effect removal:
RealdataanalysisBatcheffremoval <- sfLapply(1:nbatchremoval, function(z) performBatchremovalRealData(z))

# Apply metrics:
RealdataanalysisResults <- sfLapply(1:nmetric, function(z) evaluateMetricRealData(z))

# Stop the cluster:
sfStop()

# Save results:
save(RealdataanalysisResults, file="./FAbatchPaper/Results/RealdataanalysisResults.Rda")

# Clear the workspace:
rm(list=ls()); gc()
