# Number of iterations and CPUs to use:

niter <- 100; ncpus <- 100

# Make scenario grid for simulated data:

simulgrid <- expand.grid(iteration=1:niter, indscen=c("NoCor",  
  "CommonCor", "BatchspecificCor", "BatchClassspecificCor"), stringsAsFactors = FALSE)
simulgrid <- simulgrid[,ncol(simulgrid):1]


# Different seed for each simulated dataset:

set.seed(1234)
seeds <- sample(1000:10000000, size=nrow(simulgrid))
simulgrid$seed <- seeds

simulgrid$datasetind <- 1:nrow(simulgrid)


# Make scenario grids:
  
scenariogrid <- expand.grid(batchremmethod=c("none", "fabatch", "combat", 
  "fsvafast", "fsvaexact", "meancenter", "standardize", "ratioa", "ratiog"), 
  datasetind=simulgrid$datasetind, stringsAsFactors = FALSE)
scenariogrid <- scenariogrid[,ncol(scenariogrid):1]


# Source functions for performing the analysis on the cluster:

source("./FAbatchPaper/Functions/SimulationSnowfallFunctions.R")


# Load 'snowfall'-Package for parallel computation:
require("snowfall")


# Initiate cluster:
sfInit(parallel=TRUE, cpus=ncpus, type = "MPI")

# Export all objects to the CPUs:
sfExportAll()

# Simulate datasets:
SimulationDatasets <- sfLapply(1:nrow(simulgrid), function(z) simulateDatacrossbatch(z))

# Addon batch effect removal and classification:
SimulationResults <- sfLapply(1:nrow(scenariogrid), function(z) try({performCrossBatchPredictionSimulation(z)}))

# Stop the cluster:
sfStop()

# Save results:
save(SimulationResults, file="./FAbatchPaper/Results/SimulationCrossbatchpredResults.Rda")

# Clear the workspace:
rm(list=ls()); gc()
