# Load results:
load("./FAbatchPaper/Results/SimulationCrossbatchpredResults.Rda")


# Combine results to a data frame:
###################################

indscen <- sapply(SimulationResults, function(x) x$indscen)
iteration <- sapply(SimulationResults, function(x) x$iteration)
batchremmethod <- sapply(SimulationResults, function(x) x$method)
true1pred1 <- sapply(SimulationResults, function(x) sum(x$true1pred1))
true1pred2 <- sapply(SimulationResults, function(x) sum(x$true1pred2))
true2pred1 <- sapply(SimulationResults, function(x) sum(x$true2pred1))
true2pred2 <- sapply(SimulationResults, function(x) sum(x$true2pred2))

results <- data.frame(indscen=indscen, iteration=iteration,
  batchremmethod=batchremmethod,
  true1pred1=true1pred1, true1pred2=true1pred2,
  true2pred1=true2pred1, true2pred2=true2pred2)

results$batchremmethod <- as.character(results$batchremmethod)
results$batchremmethod[results$batchremmethod=="standardize"] <- "stand"
results$batchremmethod[results$batchremmethod=="meancenter"] <- "meanc"
results$batchremmethod <- factor(results$batchremmethod, levels=c("none", 
  "fabatch", "combat", "fsvafast", "fsvaexact", "meanc", "stand", "ratiog", "ratioa"))


  
# Calculate MCC-values:
########################

# for each combination of setting and batch effect adjustment method 
# sum up the true positives, the true negatives, the false positives
# and the false negatives over all prediction iterations in all 100 datasets:

library("plyr")
resultsum <- ddply(results, .variables=c("indscen", "batchremmethod"), .fun=summarise, true1pred1=sum(true1pred1),
  true1pred2=sum(true1pred2), true2pred1=sum(true2pred1), true2pred2=sum(true2pred2))

  
# Calculate MCC-values using the above summed up values:
  
MCC <- function(tp, tn, fp, fn)
  (tp*tn - fp*fn)/sqrt((tp+fp)*(tp+fn)*(tn+fp)*(tn+fn))

resultsum$mcc <- MCC(resultsum$true2pred2, resultsum$true1pred1,
 resultsum$true1pred2, resultsum$true2pred1)  
  

  
# Plot of the MCC-values by setting and method:
################################################  
  
library("ggplot2")

levels(resultsum$indscen) <- c("BatchClassCor", "BatchCor", "ComCor", "NoCor")
resultsum$indscen <- factor(as.character(resultsum$indscen), levels=c("NoCor", "ComCor", "BatchCor", "BatchClassCor"))

p <- ggplot(data=resultsum, aes(x=indscen, y=mcc, color=batchremmethod)) + geom_point() + geom_line(aes(x=as.numeric(indscen))) + 
  theme(axis.title.x=element_blank(), legend.position="none") + labs(y="MCC") + scale_color_discrete(name="Method")
p

ggsave(file="./FAbatchPaper/Results/Figure5.pdf", width=8, height=5)
