# Load the results: 
load("./FAbatchPaper/Results/ResultsSimulationSignalExaggeration.Rda")


# Combine results to a data frame:

withoutbr <- sapply(Results, function(x) x$withoutbr)
sva <- sapply(Results, function(x) x$sva)
fabatch <- sapply(Results, function(x) x$fabatch)

scenariogrid <- expand.grid(iteration=1:50, nbf=1:3)[,2:1]

set.seed(1234)
seeds <- sample(1000:10000000, size=nrow(scenariogrid))

scenariogrid$seed <- seeds

resultsall <- data.frame(nbf=scenariogrid$nbf, iteration=scenariogrid$iteration, 
  withoutbr=withoutbr,
  sva=sva,
  fabatch=fabatch)
  


# Mean errors when using three factors:
  
nbftemp <- 3  

colMeans(cbind(resultsall$withoutbr[resultsall$nbf==nbftemp], resultsall$sva[resultsall$nbf==nbftemp],
  resultsall$fabatch[resultsall$nbf==nbftemp]))  

wilcox.test(resultsall$withoutbr[resultsall$nbf==nbftemp], resultsall$sva[resultsall$nbf==nbftemp], paired=TRUE)


# Mean errors when using one factor:

nbftemp <- 1

colMeans(cbind(resultsall$withoutbr[resultsall$nbf==nbftemp], resultsall$sva[resultsall$nbf==nbftemp],
  resultsall$fabatch[resultsall$nbf==nbftemp]))  

wilcox.test(resultsall$withoutbr[resultsall$nbf==nbftemp], resultsall$sva[resultsall$nbf==nbftemp], paired=TRUE)


# Mean errors when using two factors:

nbftemp <- 2

colMeans(cbind(resultsall$withoutbr[resultsall$nbf==nbftemp], resultsall$sva[resultsall$nbf==nbftemp],
  resultsall$fabatch[resultsall$nbf==nbftemp]))  

wilcox.test(resultsall$withoutbr[resultsall$nbf==nbftemp], resultsall$sva[resultsall$nbf==nbftemp], paired=TRUE)



# Mean error without batch effect removal:

mean(resultsall$withoutbr)
