######################################################################################
#                                                                                    #
#                  Get VIs for different class imbalance levels                      #
#                                                                                    #
######################################################################################


# IMPORTANT: Set working directory here
setwd("AUC_VIM/Comparison_Studies/Real_Data/")

# Source the function used to get VIs     
source("Functions/grow_RF.r")
source("Functions/calc_VIMs.r") 


require("party")
                                                                                  
######################################################################################
# Data preparation                                                                   #
######################################################################################

# Load the data:

arabidopsis <- read.table("Dataset/1471-2105-5-132-S4.txt", header = TRUE, sep = " ", na.string = "X")


# Remove cases with missing values and variables not to be used in the analysis:

arabidopsis <- subset(arabidopsis, complete.cases(arabidopsis))
arabidopsis <- arabidopsis[, !(names(arabidopsis) %in% c("X0", "loc"))]

# Stratify data in both classes:

arabidopsis_plus  <- arabidopsis[arabidopsis$edit == "+",]
arabidopsis_minus <- arabidopsis[arabidopsis$edit == "-",] 
plus_index        <- rownames(arabidopsis_plus)
minus_index       <- rownames(arabidopsis_minus)


######################################################################################
# Call Function 'calc_VIMs()' for different class imbalance levels:                  #
# Imbalance levels: 0.01, 0.05, 0.10, 0.15, 0.20, 0.25, 0.30, 0.35, 0.40, 0.45       #
######################################################################################


# 1% imbalance
imb_1 <- calc_VIMs(imbalance = 0.01)
save(imb_1, file = "R_Objects/imb_1.Rda")

# 5% imbalance
imb_5 <- calc_VIMs(imbalance = 0.05)
save(imb_5, file = "R_Objects/imb_5.Rda")

# 10% imbalance
imb_10 <- calc_VIMs(imbalance = 0.10)
save(imb_10, file = "R_Objects/imb_10.Rda")

# 15% imbalance
imb_15 <- calc_VIMs(imbalance = 0.15)
save(imb_15, file = "R_Objects/imb_15.Rda")

# 20% imbalance
imb_20 <- calc_VIMs(imbalance = 0.20)
save(imb_20, file = "R_Objects/imb_20.Rda")

# 25% imbalance
imb_25 <- calc_VIMs(imbalance = 0.25)
save(imb_25, file = "R_Objects/imb_25.Rda")

# 30% imbalance
imb_30 <- calc_VIMs(imbalance = 0.30)
save(imb_30, file = "R_Objects/imb_30.Rda")

# 35% imbalance
imb_35 <- calc_VIMs(imbalance = 0.35)
save(imb_35, file = "R_Objects/imb_35.Rda")

# 40% imbalance
imb_40 <- calc_VIMs(imbalance = 0.40)
save(imb_40, file = "R_Objects/imb_40.Rda")

# 45% imbalance
imb_45 <- calc_VIMs(imbalance = 0.45)
save(imb_45, file = "R_Objects/imb_45.Rda")


                


