######################################################################################
#                                                                                    #
#        Helper function: for evaluation of VI-rankings using the AUC                #
#                                                                                    #
#   Input:  objects containing VIs which were created in files VI_computation*       #
#                                                                                    #
#   Output: list of AUC-values                                                       #
#                                                                                    #
######################################################################################


require(ROCR)


# Function 'calculate' is called by function 'calc_AUC'
# Return AUC for a vector of importance measures

calculate <- function(x){
    # 1st part of vector corresponds to VIs of original predictors
    pred <- prediction(x, rep(c(1,0), each = length(x)/2))
    return(unlist(performance(pred, measure = "auc")@y.values))
}


calc_AUC <- function(object){

    # Apply function 'calculate' for each iteration (AUC-based perm. VIM)
    AUC_AUC_VI <- apply(object$AUC_VI, 2, calculate)

    # Apply function 'calculate' for each iteration (ER-based perm. VIM)
    AUC_ER_VI  <- apply(object$ER_VI,  2, calculate)

    return(list(AUC_AUC_VI = AUC_AUC_VI, AUC_ER_VI = AUC_ER_VI))
}
