######################################################################################
#                                                                                    #
#     Helper function: for adding noise predictors, growing RF and getting VIs       #
#                                                                                    #
#   Input:  vector of indices denoting observations from plus-class to be sampled    #
#                                                                                    #
#   Output: vector of predictor rankings (by ER-based and AUC-based perm. VIM)       #
#                                                                                    #
######################################################################################


grow_RF <- function(plus_index_sel){

    # Create data containing only a subsample from plus-class
    
    arabidopsis_subset <- arabidopsis[rownames(arabidopsis) %in% c(minus_index, plus_index_sel),]

    # Add noise predictors:
    # (noise predictors are created by permuting the values of original predictors)

    arabidopsis_noise <- data.frame(apply(arabidopsis_subset[,-1], 2, sample),
                                    stringsAsFactors = TRUE)

    arabidopsis_noise$fe  <- as.numeric(as.character(arabidopsis_noise$fe))
    arabidopsis_noise$dfe <- as.numeric(as.character(arabidopsis_noise$dfe))

    colnames(arabidopsis_noise) <- paste("noise", 1:dim(arabidopsis_noise)[2], sep = "")

    # Dataset containing the original 43 predictors and further 43 noise predictors

    arabidopsis_subset <- cbind(arabidopsis_subset, arabidopsis_noise)


    # Function call to create a random forest:

    forest_control <- cforest_control(teststat     = "quad",
                                      testtype     = "Univ",
                                      mincriterion = 0,
                                      minsplit     = 0,
                                      minbucket    = 0,
                                      ntree        = 500,
                                      replace      = FALSE)

    forest <- cforest(edit ~ ., data = arabidopsis_subset,
                                controls = forest_control)


    # Calculate VIs: 
                                
    varimp.AUC <- varimpAUC(forest)
    varimp.ER  <- varimp(forest)

    return(list(varimp.AUC = varimp.AUC, varimp.ER  = varimp.ER))
    
}

