######################################################################################
#                                                                                    #
#                  Get VIs for different imbalance levels                            # 
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory here
setwd("AUC_VIM/Comparison_Studies/Simulated_Data/Comparison_AUC_ER/")

# Source the function used to get VIs
source("../Functions/calc_VIMs.r")

######################################################################################
# Data setting for total sample size fixed to 100 observations                       #
######################################################################################

# 1% imbalance
# not applicable

# 5% imbalance
nobs15nobs295  <- calc_VIMs(nobs1 = 5,  nobs2 = 95)

# 10% imbalance
nobs110nobs290 <- calc_VIMs(nobs1 = 10, nobs2 = 90)

# 20% imbalance
nobs120nobs280 <- calc_VIMs(nobs1 = 20, nobs2 = 80)

# 30% imbalance
nobs130nobs270 <- calc_VIMs(nobs1 = 30, nobs2 = 70)

# 40% imbalance
nobs140nobs260 <- calc_VIMs(nobs1 = 40, nobs2 = 60)

# 50% imbalance
nobs150nobs250 <- calc_VIMs(nobs1 = 50, nobs2 = 50)

# create list of objects
# (from completely balanced up to most extreme imbalanced)

list100 <- list(nobs150nobs250, nobs140nobs260, nobs130nobs270,
                nobs120nobs280, nobs110nobs290, nobs15nobs295)
                
save(list100, file = "R_Objects/list100.Rda")


######################################################################################
# Data setting for total sample size fixed to 500 observations                       #
######################################################################################

# 1% imbalance
nobs15nobs2495   <- calc_VIMs(nobs1 = 5,   nobs2 = 495)

# 5% imbalance
nobs125nobs2475  <- calc_VIMs(nobs1 = 25,  nobs2 = 475)

# 10% imbalance
nobs150nobs2450  <- calc_VIMs(nobs1 = 50,  nobs2 = 450)

# 20% imbalance
nobs1100nobs2400 <- calc_VIMs(nobs1 = 100, nobs2 = 400)

# 30% imbalance
nobs1150nobs2350 <- calc_VIMs(nobs1 = 150, nobs2 = 350)

# 40% imbalance
nobs1200nobs2300 <- calc_VIMs(nobs1 = 200, nobs2 = 300)

# 50% imbalance
nobs1250nobs2250 <- calc_VIMs(nobs1 = 250, nobs2 = 250)


# Create list of objects
# (from completely balanced up to most extreme imbalanced)

list500 <- list(nobs1250nobs2250, nobs1200nobs2300, nobs1150nobs2350,
                nobs1100nobs2400, nobs150nobs2450,  nobs125nobs2475, nobs15nobs2495)

save(list500, file = "R_Objects/list500.Rda")

######################################################################################
# Data setting for total sample size fixed to 1000 observations                      #
######################################################################################

# 1% imbalance
nobs110nobs2990  <- calc_VIMs(nobs1 = 10,  nobs2 = 990)

# 5% imbalance
nobs150nobs2950  <- calc_VIMs(nobs1 = 50,  nobs2 = 950)

# 10% imbalance
nobs1100nobs2900 <- calc_VIMs(nobs1 = 100, nobs2 = 900)

# 20% imbalance
nobs1200nobs2800 <- calc_VIMs(nobs1 = 200, nobs2 = 800)

# 30% imbalance
nobs1300nobs2700 <- calc_VIMs(nobs1 = 300, nobs2 = 700)

# 40% imbalance
nobs1400nobs2600 <- calc_VIMs(nobs1 = 400, nobs2 = 600)

# 50% imbalance
nobs1500nobs2500 <- calc_VIMs(nobs1 = 500, nobs2 = 500)

list1000 <- list(nobs1500nobs2500, nobs1400nobs2600, nobs1300nobs2700,
                 nobs1200nobs2800, nobs1100nobs2900, nobs150nobs2950, nobs110nobs2990)
         
save(list1000, file = "R_Objects/list1000.Rda")        
                 
