######################################################################################
#                                                                                    #
#    Get VIs for different imbalance levels                                          #
#    1. VIs obtained by AUC-VIM                                                      #
#    2. VIs obtained by ER-VIM computed only from observations from minority class   #
#                                                                                    #
######################################################################################
          
require(party) 
   
# IMPORTANT: Set working directory here
setwd("AUC_VIM/Comparison_Studies/Simulated_Data/Comparison_AUC_ER_computed_from_minority_class/")

# Source the modified varimp() function to compute ER-based VIs using only observations
# from the minority class
source("../Functions/varimp_minority_class.r")

# Source the function used to get VIs
source("../Functions/calc_VIMs_minority_class.r")

######################################################################################
# Data setting for total sample size fixed to 100 observations                       #
######################################################################################

# 1% imbalance
# not applicable

# 5% imbalance
nobs15nobs295  <- calc_VIMs_minority_class(nobs1 = 5,  nobs2 = 95, niter = 100)

# 10% imbalance
nobs110nobs290 <- calc_VIMs_minority_class(nobs1 = 10, nobs2 = 90, niter = 100)

# 20% imbalance
nobs120nobs280 <- calc_VIMs_minority_class(nobs1 = 20, nobs2 = 80, niter = 100)

# 30% imbalance
nobs130nobs270 <- calc_VIMs_minority_class(nobs1 = 30, nobs2 = 70, niter = 100)

# 40% imbalance
nobs140nobs260 <- calc_VIMs_minority_class(nobs1 = 40, nobs2 = 60, niter = 100)

# 50% imbalance
nobs150nobs250 <- calc_VIMs_minority_class(nobs1 = 50, nobs2 = 50, niter = 100)

# create list of objects
# (from completely balanced up to most extreme imbalanced)

list100 <- list(nobs150nobs250, nobs140nobs260, nobs130nobs270,
                nobs120nobs280, nobs110nobs290, nobs15nobs295)


save(list100,  file = "R_Objects/list100.Rda")

######################################################################################
# Data setting for total sample size fixed to 500 observations                       #
######################################################################################

# 1% imbalance
nobs15nobs2495   <- calc_VIMs_minority_class(nobs1 = 5,   nobs2 = 495, niter = 100)

# 5% imbalance
nobs125nobs2475  <- calc_VIMs_minority_class(nobs1 = 25,  nobs2 = 475, niter = 100)

# 10% imbalance
nobs150nobs2450  <- calc_VIMs_minority_class(nobs1 = 50,  nobs2 = 450, niter = 100)

# 20% imbalance
nobs1100nobs2400 <- calc_VIMs_minority_class(nobs1 = 100, nobs2 = 400, niter = 100)

# 30% imbalance
nobs1150nobs2350 <- calc_VIMs_minority_class(nobs1 = 150, nobs2 = 350, niter = 100)

# 40% imbalance
nobs1200nobs2300 <- calc_VIMs_minority_class(nobs1 = 200, nobs2 = 300, niter = 100)

# 50% imbalance
nobs1250nobs2250 <- calc_VIMs_minority_class(nobs1 = 250, nobs2 = 250, niter = 100)


# create list of objects
# (from completely balanced up to most extreme imbalanced)

list500 <- list(nobs1250nobs2250, nobs1200nobs2300, nobs1150nobs2350,
                nobs1100nobs2400, nobs150nobs2450,  nobs125nobs2475, nobs15nobs2495)


save(list500,  file = "R_Objects/list500.Rda")

######################################################################################
# Data setting for total sample size fixed to 1000 observations                      #
######################################################################################

# 1% imbalance
nobs110nobs2990  <- calc_VIMs_minority_class(nobs1 = 10,  nobs2 = 990, niter = 100)

# 5% imbalance
nobs150nobs2950  <- calc_VIMs_minority_class(nobs1 = 50,  nobs2 = 950, niter = 100)

# 10% imbalance
nobs1100nobs2900 <- calc_VIMs_minority_class(nobs1 = 100, nobs2 = 900, niter = 100)

# 20% imbalance
nobs1200nobs2800 <- calc_VIMs_minority_class(nobs1 = 200, nobs2 = 800, niter = 100)

# 30% imbalance
nobs1300nobs2700 <- calc_VIMs_minority_class(nobs1 = 300, nobs2 = 700, niter = 100)

# 40% imbalance
nobs1400nobs2600 <- calc_VIMs_minority_class(nobs1 = 400, nobs2 = 600, niter = 100)

# 50% imbalance
nobs1500nobs2500 <- calc_VIMs_minority_class(nobs1 = 500, nobs2 = 500, niter = 100)

list1000 <- list(nobs1500nobs2500, nobs1400nobs2600, nobs1300nobs2700,
                 nobs1200nobs2800, nobs1100nobs2900, nobs150nobs2950, nobs110nobs2990)


save(list1000, file = "R_Objects/list1000.Rda")

