######################################################################################
#                                                                                    #
# Function for computing differences in performance (measured by AUC)                #
#                                                                                    #
# Input: - list of R objects (created in 'VI_computation')                           #
#        - specification which effects are to be distinguished from noise predictors #
#          chose between effect strength ''all''/''weak''/''moderate''/''strong''    #
#                                                                                    #
# Output: list of difference in AUCs                                                 #
#                                                                                    #
######################################################################################

get_AUC_difference <- function(liste = list100, effect = "all"){
                            
  nolevels   <- length(liste)
  difference <- list()

  for (i in 1:nolevels){
    AUC_AUC_VI <- apply(liste[[i]]$AUC_VI, 2, function(x) get_AUC(VI = x, effect = effect))
    AUC_ER_VI  <- apply(liste[[i]]$ER_VI,  2, function(x) get_AUC(VI = x, effect = effect))
    difference[[i]] <- AUC_AUC_VI - AUC_ER_VI 
  }
  
  return(difference)

}

