######################################################################################
#                                                                                    #
#                              Plot VI rankings                                      #
#                                                                                    #
#                      R-code for reproducing Figure 1                               #
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory where AUC_VIM folder is stored
setwd("AUC_VIM/Comparison_Studies/Real_Data/")

# Load computed VIs
load("R_Objects/imb_50.Rda")

setwd("Results/")


# Get mean ER-based VIs (over 100 versions of the extended balanced dataset)
meanVI <- apply(imb_50$ER_VI, 1, mean)


# VIs using ER-based permutation VIM

graphics.off()

pdf(file = "Figure1.pdf", width = 25, height = 10)
par(cex.main = 2.8, cex.axis = 1.8, cex.lab = 2.5, oma = c(2,0,0,0), mar = c(5,6,3,0))

barplot(meanVI,
        ylab = "", 
        las  = 2,
        ylim = c(0, 0.04), 
        xlab = "",
        main = "Mean VIs for Extended C-to-U Conversion Dataset")

graphics.off()


