######################################################################################
#                                                                                    #
#                          Plot AUC distributions                                    #  
#                                                                                    # 
#                      R-Code for reproducing Figure 8                               # 
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory where AUC_VIM folder is stored
setwd("AUC_VIM/Comparison_Studies/Real_Data/")

# Load computed VIs
load("R_Objects/imb_1.Rda")
load("R_Objects/imb_5.Rda")
load("R_Objects/imb_10.Rda")
load("R_Objects/imb_15.Rda")
load("R_Objects/imb_20.Rda")
load("R_Objects/imb_25.Rda")
load("R_Objects/imb_30.Rda")
load("R_Objects/imb_35.Rda")
load("R_Objects/imb_40.Rda")
load("R_Objects/imb_45.Rda")
load("R_Objects/imb_50.Rda")

# Source the function used to compute the AUCs
source("Functions/calc_AUC.r")

setwd("Results/")


##################################################################
# Get AUC values for all imbalance objects                       #
##################################################################

for (i in c(1, 5*(1:10))){
  assign(paste("AUC_", i, "_identified", sep =""),
         calc_AUC(object = get(paste("imb_", i, sep = "")))
  )
}

# Combine results from different class imbalances to one list object:

liste <- list(AUC_50 = AUC_50_identified,
              AUC_45 = AUC_45_identified,
              AUC_40 = AUC_40_identified,
              AUC_35 = AUC_35_identified,
              AUC_30 = AUC_30_identified,
              AUC_25 = AUC_25_identified,
              AUC_20 = AUC_20_identified,
              AUC_15 = AUC_15_identified,
              AUC_10 = AUC_10_identified,
              AUC_5  = AUC_5_identified,
              AUC_1  = AUC_1_identified)
              

##################################################################
# Plot distribution of AUC-values for varying imbalance levels   #
# (Figure 8)                                                     #
##################################################################


graphics.off()

pdf(file = "Figure8.pdf", width = 8, height = 7)


nolevels <- length(liste)

par(cex.axis = 1.2, cex.lab = 1.4, mar = c(5,4.5,1,1))  

plot.new()
plot.window(xlim = c(0, nolevels * 3), ylim = c(0.2,1))

abline(h = 1, lty = 2)
abline(h = 0.5, lty = 2, col = "darkgrey")

for (i in 1:nolevels){

  boxplot(liste[[i]]$AUC_AUC_VI, liste[[i]]$AUC_ER_VI,
    add  = TRUE,
    at   = 1:2 + 3 * (i-1),
    ylim = c(0,1),
    col  = c("lightgrey", "white"),
    main = "",
    xlab = "Class Imbalance Level",
    ylab = "AUC",
    xaxt = "n"
  )
}

axis(1, at = 3 * ((1:nolevels) - 0.5), labels = c("50%", "45%", "40%", "35%",
    "30%", "25%", "20%", "15%", "10%", "5%", "1%"))
    

graphics.off()


