######################################################################################
#                                                                                    #
#     Get VIs for different minsplit, minbucket & mincriterion for balanced data     #
#                                                                                    #
#     sample size fixed to n = 100                                                   #
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory here
setwd("AUC_VIM/Comparison_Studies/Simulated_Data/Comparison_AUC_ER/Early_Stopping/")

# Source the function used to get VIs
source('../../Functions/calc_VIMs.r')

####################
#   Balanced data  #
####################

##################
#    minbucket   #
##################

# Call function calc_VIMs() for different values of minbucket
                                                                                    
nobs150nobs250minbuck0  <- calc_VIMs(nobs1 = 50, nobs2 = 50, minbuck = 0,  niter = 1000) 
nobs150nobs250minbuck5  <- calc_VIMs(nobs1 = 50, nobs2 = 50, minbuck = 5,  niter = 1000)
nobs150nobs250minbuck10 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minbuck = 10, niter = 1000)
nobs150nobs250minbuck20 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minbuck = 20, niter = 1000) 
nobs150nobs250minbuck30 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minbuck = 30, niter = 1000)
nobs150nobs250minbuck40 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minbuck = 40, niter = 1000)
nobs150nobs250minbuck50 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minbuck = 50, niter = 1000)


# Store objects in a list (for plotting results)

imb50_ss100_minbuck <- list(nobs150nobs250minbuck0  = nobs150nobs250minbuck0,
                            nobs150nobs250minbuck5  = nobs150nobs250minbuck5,
                            nobs150nobs250minbuck10 = nobs150nobs250minbuck10,
                            nobs150nobs250minbuck20 = nobs150nobs250minbuck20,
                            nobs150nobs250minbuck30 = nobs150nobs250minbuck30,
                            nobs150nobs250minbuck40 = nobs150nobs250minbuck40,
                            nobs150nobs250minbuck50 = nobs150nobs250minbuck50)
                                 
save(imb50_ss100_minbuck, file = "R_Objects/imb50_ss100_minbuck.Rda")


##################
#    minsplit    #
##################

# Call function calc_VIMs() for different values of minsplit

nobs150nobs250minsp0  <- calc_VIMs(nobs1 = 50, nobs2 = 50, minsp = 0,  niter = 1000) 
nobs150nobs250minsp5  <- calc_VIMs(nobs1 = 50, nobs2 = 50, minsp = 5,  niter = 1000)
nobs150nobs250minsp10 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minsp = 10, niter = 1000)
nobs150nobs250minsp20 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minsp = 20, niter = 1000) 
nobs150nobs250minsp30 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minsp = 30, niter = 1000)
nobs150nobs250minsp40 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minsp = 40, niter = 1000)
nobs150nobs250minsp50 <- calc_VIMs(nobs1 = 50, nobs2 = 50, minsp = 50, niter = 1000)


# Store objects in a list (for plotting results)

imb50_ss100_minsp <- list(nobs150nobs250minsp0  = nobs150nobs250minsp0,
                          nobs150nobs250minsp5  = nobs150nobs250minsp5,
                          nobs150nobs250minsp10 = nobs150nobs250minsp10,
                          nobs150nobs250minsp20 = nobs150nobs250minsp20,
                          nobs150nobs250minsp30 = nobs150nobs250minsp30,
                          nobs150nobs250minsp40 = nobs150nobs250minsp40,
                          nobs150nobs250minsp50 = nobs150nobs250minsp50)
                                 
save(imb50_ss100_minsp, file = "R_Objects/imb50_ss100_minsp.Rda")


##################
#  mincriterion  #
##################

# Call function calc_VIMs() for different values of mincriterion

nobs150nobs250mincrit0    <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0,    niter = 1000)
nobs150nobs250mincrit0.5  <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0.5,  niter = 1000)
nobs150nobs250mincrit0.6  <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0.6,  niter = 1000)
nobs150nobs250mincrit0.7  <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0.7,  niter = 1000)
nobs150nobs250mincrit0.8  <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0.8,  niter = 1000)
nobs150nobs250mincrit0.9  <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0.9,  niter = 1000)
nobs150nobs250mincrit0.95 <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0.95, niter = 1000)
nobs150nobs250mincrit0.99 <- calc_VIMs(nobs1 = 50, nobs2 = 50, mincrit = 0.99, niter = 1000)


# Store objects in a list (for plotting results)

imb50_ss100_mincrit <- list(nobs150nobs250mincrit0    = nobs150nobs250mincrit0,
                            nobs150nobs250mincrit0.5  = nobs150nobs250mincrit0.5,
                            nobs150nobs250mincrit0.6  = nobs150nobs250mincrit0.6,
                            nobs150nobs250mincrit0.7  = nobs150nobs250mincrit0.7,
                            nobs150nobs250mincrit0.8  = nobs150nobs250mincrit0.8,
                            nobs150nobs250mincrit0.9  = nobs150nobs250mincrit0.9,
                            nobs150nobs250mincrit0.95 = nobs150nobs250mincrit0.95,
                            nobs150nobs250mincrit0.99 = nobs150nobs250mincrit0.99)
                                    
save(imb50_ss100_mincrit, file = "R_Objects/imb50_ss100_mincrit.Rda")
