######################################################################################
#                                                                                    #
#   Get VIs for different minsplit, minbucket & mincriterion for unbalanced data     #
#                                                                                    #
#   sample size fixed to n = 100 and imbalance level to 10%                          #
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory here
setwd("AUC_VIM/Comparison_Studies/Simulated_Data/")

# Source the function used to get VIs
source('Functions/calc_VIMs.r')

####################
#  Unalanced data  #
####################

##################
#    minbucket   #
##################

# Call function calc_VIMs() for different values of minbucket
                                                                                    
nobs110nobs290minbuck0  <- calc_VIMs(nobs1 = 10, nobs2 = 90, minbuck = 0,  niter = 1000) 
nobs110nobs290minbuck5  <- calc_VIMs(nobs1 = 10, nobs2 = 90, minbuck = 5,  niter = 1000)
nobs110nobs290minbuck10 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minbuck = 10, niter = 1000)
nobs110nobs290minbuck20 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minbuck = 20, niter = 1000) 
nobs110nobs290minbuck30 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minbuck = 30, niter = 1000)
nobs110nobs290minbuck40 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minbuck = 40, niter = 1000)
nobs110nobs290minbuck50 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minbuck = 50, niter = 1000)


# Store objects in a list (for plotting results)

imb10_ss100_minbuck <- list(nobs110nobs290minbuck0  = nobs110nobs290minbuck0,
                            nobs110nobs290minbuck5  = nobs110nobs290minbuck5,
                            nobs110nobs290minbuck10 = nobs110nobs290minbuck10,
                            nobs110nobs290minbuck20 = nobs110nobs290minbuck20,
                            nobs110nobs290minbuck30 = nobs110nobs290minbuck30,
                            nobs110nobs290minbuck40 = nobs110nobs290minbuck40,
                            nobs110nobs290minbuck50 = nobs110nobs290minbuck50)
                                 
save(imb10_ss100_minbuck, file = "R_Objects/imb10_ss100_minbuck.Rda")


##################
#    minsplit    #
##################

# Call function calc_VIMs() for different values of minsplit

nobs110nobs290minsp0  <- calc_VIMs(nobs1 = 10, nobs2 = 90, minsp = 0,  niter = 1000) 
nobs110nobs290minsp5  <- calc_VIMs(nobs1 = 10, nobs2 = 90, minsp = 5,  niter = 1000)
nobs110nobs290minsp10 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minsp = 10, niter = 1000)
nobs110nobs290minsp20 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minsp = 20, niter = 1000) 
nobs110nobs290minsp30 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minsp = 30, niter = 1000)
nobs110nobs290minsp40 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minsp = 40, niter = 1000)
nobs110nobs290minsp50 <- calc_VIMs(nobs1 = 10, nobs2 = 90, minsp = 50, niter = 1000)


# Store objects in a list (for plotting results)

imb10_ss100_minsp <- list(nobs110nobs290minsp0  = nobs110nobs290minsp0,
                          nobs110nobs290minsp5  = nobs110nobs290minsp5,
                          nobs110nobs290minsp10 = nobs110nobs290minsp10,
                          nobs110nobs290minsp20 = nobs110nobs290minsp20,
                          nobs110nobs290minsp30 = nobs110nobs290minsp30,
                          nobs110nobs290minsp40 = nobs110nobs290minsp40,
                          nobs110nobs290minsp50 = nobs110nobs290minsp50)
                                 
save(imb10_ss100_minsp, file = "R_Objects/imb10_ss100_minsp.Rda")


##################
#  mincriterion  #
##################

# Call function calc_VIMs() for different values of mincriterion

nobs110nobs290mincrit0    <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0,    niter = 1000)
nobs110nobs290mincrit0.5  <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0.5,  niter = 1000)
nobs110nobs290mincrit0.6  <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0.6,  niter = 1000)
nobs110nobs290mincrit0.7  <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0.7,  niter = 1000)
nobs110nobs290mincrit0.8  <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0.8,  niter = 1000)
nobs110nobs290mincrit0.9  <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0.9,  niter = 1000)
nobs110nobs290mincrit0.95 <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0.95, niter = 1000)
nobs110nobs290mincrit0.99 <- calc_VIMs(nobs1 = 10, nobs2 = 90, mincrit = 0.99, niter = 1000)


# Store objects in a list (for plotting results)

imb10_ss100_mincrit <- list(nobs110nobs290mincrit0    = nobs110nobs290mincrit0,
                            nobs110nobs290mincrit0.5  = nobs110nobs290mincrit0.5,
                            nobs110nobs290mincrit0.6  = nobs110nobs290mincrit0.6,
                            nobs110nobs290mincrit0.7  = nobs110nobs290mincrit0.7,
                            nobs110nobs290mincrit0.8  = nobs110nobs290mincrit0.8,
                            nobs110nobs290mincrit0.9  = nobs110nobs290mincrit0.9,
                            nobs110nobs290mincrit0.95 = nobs110nobs290mincrit0.95,
                            nobs110nobs290mincrit0.99 = nobs110nobs290mincrit0.99)
                                    
save(imb10_ss100_mincrit, file = "R_Objects/imb10_ss100_mincrit.Rda")
