######################################################################################
#                                                                                    #
#      Call function plot_AUC_eval_early_stopping() to plot AUC distributions        #  
#                                                                                    #
#   R-Code for reproducing: * Figure 5                                               #  
#                           * Figure 6                                               # 
#                           * Figure 7                                               #
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory where AUC_VIM folder is stored
setwd("AUC_VIM/Comparison_Studies/Simulated_Data/Comparison_AUC_ER/Early_Stopping/")

# Load computed VIs for unbalanced data
load("R_Objects/imb10_ss100_minbuck.Rda")
load("R_Objects/imb10_ss100_minsp.Rda")
load("R_Objects/imb10_ss100_mincrit.Rda")

# Load computed VIs for balanced data
load("R_Objects/imb50_ss100_minbuck.Rda")
load("R_Objects/imb50_ss100_minsp.Rda")
load("R_Objects/imb50_ss100_mincrit.Rda")

# Source the function used to plot AUCs             
source('../../Functions/get_AUC.r')
source('../../Functions/plot_AUC_eval_early_stopping.r')


setwd("Results/")

##################
#    minbucket   #
##################

# Figure 5

# Show AUC distr. for balanced data
plot_AUC_eval_early_stopping(liste = imb50_ss100_minbuck,
                          effect   = "all",
                          filename = "Figure5_left",
                          xlabname = "minbucket",
                          plotmain = "Balanced Data")

# Show AUC distr. for unbalanced data
plot_AUC_eval_early_stopping(liste = imb10_ss100_minbuck,
                          effect   = "all",
                          filename = "Figure5_right",
                          xlabname = "minbucket",
                          plotmain = "Unbalanced Data")
                          
##################
#    minsplit    #
##################

# Figure 6

# Show AUC distr. for balanced data
plot_AUC_eval_early_stopping(liste = imb50_ss100_minsp,
                          effect   = "all",
                          filename = "Figure6_left",
                          xlabname = "minsplit",
                          plotmain = "Balanced Data")

# Show AUC distr. for unbalanced data
plot_AUC_eval_early_stopping(liste = imb10_ss100_minsp,
                          effect   = "all",
                          filename = "Figure6_right",
                          xlabname = "minsplit",
                          plotmain = "Unbalanced Data")
                          

##################
#  mincriterion  #
##################

# Figure 7

# Show AUC distr. for balanced data
plot_AUC_eval_early_stopping(liste = imb50_ss100_mincrit,
                          effect   = "all",
                          plotmain = "Balanced Data",
                          filename = "Figure7_left",
                          xlabname = "mincriterion",
                          labelnames = c("0","0.5","0.6","0.7","0.8",
                                         "0.9", "0.95", "0.99"))

# Show AUC distr. for unbalanced data
plot_AUC_eval_early_stopping(liste = imb10_ss100_mincrit,
                          effect   = "all",
                          plotmain = "Unbalanced Data",
                          filename = "Figure7_right",
                          xlabname = "mincriterion",
                          labelnames = c("0","0.5","0.6","0.7","0.8",
                                         "0.9", "0.95", "0.99"))


