######################################################################################
#                                                                                    #
#           Call function plot_AUC_eval() to plot AUC distributions                  #
#                                                                                    #
#   R-Code for reproducing: * Figure 3                                               #  
#                           * Figure 4                                               # 
#                           * Additional File 2                                      #
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory where AUC_VIM folder is stored
setwd("AUC_VIM/Comparison_Studies/Simulated_Data/Comparison_AUC_ER/")

# Load computed VIs
load("R_Objects/list100.Rda") 
load("R_Objects/list500.Rda")
load("R_Objects/list1000.Rda")

# Source the function used to plot AUCs
source("../Functions/get_AUC.r")
source("../Functions/plot_AUC_eval.r")


setwd("Results/")

# Figure 3
# Show AUC distr. for all sample sizes and for all effect strengths
plot_AUC_eval(list100,  effect = "all", plotmain = "Sample Size n = 100",  filename = "Figure3_left")
plot_AUC_eval(list500,  effect = "all", plotmain = "Sample Size n = 500",  filename = "Figure3_middle")
plot_AUC_eval(list1000, effect = "all", plotmain = "Sample Size n = 1000", filename = "Figure3_right")


# Figure 4
# Show AUC distr. for sample size 100 separately for each effect strength
plot_AUC_eval(list100, effect = "weak",     plotmain = "Weak Effects",     filename = "Figure4_left")
plot_AUC_eval(list100, effect = "moderate", plotmain = "Moderate Effects", filename = "Figure4_middle")
plot_AUC_eval(list100, effect = "strong",   plotmain = "Strong Effects",   filename = "Figure4_right")



# Additional File 2 (a)
# Show AUC distr. for sample size 500 separately for each effect strength
plot_AUC_eval(list500, effect = "weak",     plotmain = "Weak Effects",     filename = "AddFile2_a_left")
plot_AUC_eval(list500, effect = "moderate", plotmain = "Moderate Effects", filename = "AddFile2_a_middle")
plot_AUC_eval(list500, effect = "strong",   plotmain = "Strong Effects",   filename = "AddFile2_a_right")
                              
# Additional File 2 (b)
# Show AUC distr. for sample size 1000 separately for each effect strength
plot_AUC_eval(list1000, effect = "weak",     plotmain = "Weak Effects",     filename = "AddFile2_b_left")
plot_AUC_eval(list1000, effect = "moderate", plotmain = "Moderate Effects", filename = "AddFile2_b_middle")
plot_AUC_eval(list1000, effect = "strong",   plotmain = "Strong Effects",   filename = "AddFile2_b_right")

