######################################################################################
#                                                                                    #
#          Call function 'plot_AUC_eval()' to plot AUC distributions                 #  
#                                                                                    #  
#                   R-Code for reproducing Additional File 1                         # 
#                                                                                    #
######################################################################################

# IMPORTANT: Set working directory where AUC_VIM folder is stored
setwd("AUC_VIM/Comparison_Studies/Simulated_Data/Comparison_AUC_ER_computed_from_minority_class/")

# Load computed VIs
load("R_Objects/list100.Rda") 
load("R_Objects/list500.Rda")
load("R_Objects/list1000.Rda")

# Source the function used to compute and plot AUCs 
source("../Functions/get_AUC.r")
source("../Functions/plot_AUC_eval.r")


setwd("Results/")

# I.

# Show AUC distr. for all sample sizes and for all effect sizes
plot_AUC_eval(list100,  effect = "all", plotmain = "Sample Size n = 100",  filename = "AddFile1_I_left")
plot_AUC_eval(list500,  effect = "all", plotmain = "Sample Size n = 500",  filename = "AddFile1_I_middle")
plot_AUC_eval(list1000, effect = "all", plotmain = "Sample Size n = 1000", filename = "AddFile1_I_right")


# II.

# (a) Show AUC distr. for sample size 100 separately for each effect size
plot_AUC_eval(list100, effect = "weak",     plotmain = "Weak Effects",     filename = "AddFile1_IIa_left")
plot_AUC_eval(list100, effect = "moderate", plotmain = "Moderate Effects", filename = "AddFile1_IIa_middle")
plot_AUC_eval(list100, effect = "strong",   plotmain = "Strong Effects",   filename = "AddFile1_IIa_right")


# (b) Show AUC distr. for sample size 500 separately for each effect size
plot_AUC_eval(list500, effect = "weak",     plotmain = "Weak Effects",     filename = "AddFile1_IIb_left")
plot_AUC_eval(list500, effect = "moderate", plotmain = "Moderate Effects", filename = "AddFile1_IIb_middle")
plot_AUC_eval(list500, effect = "strong",   plotmain = "Strong Effects",   filename = "AddFile1_IIb_right")


# (c) Show AUC distr. for sample size 1000 separately for each effect size
plot_AUC_eval(list1000, effect = "weak",     plotmain = "Weak Effects",     filename = "AddFile1_IIc_left")
plot_AUC_eval(list1000, effect = "moderate", plotmain = "Moderate Effects", filename = "AddFile1_IIc_middle")
plot_AUC_eval(list1000, effect = "strong",   plotmain = "Strong Effects",   filename = "AddFile1_IIc_right")



