######################################################################################
#                                                                                    #
# Helper function: for evaluation of one VI-ranking using the AUC                    #
#                                                                                    #
# Input: - vector of VIs                                                             #
#        - specification which effects are to be distinguished from noise predictors #
#          chose between effect strength ''all''/''weak''/''moderate''/''strong''    #
#                                                                                    #
# Output: AUC                                                                        #
#                                                                                    #
######################################################################################

require(ROCR)

get_AUC <- function(VI, effect) {

      if (effect == "all")      pred <- prediction(VI, rep(c(1,0), c(15, 50)))
      if (effect == "weak")     pred <- prediction(VI[c(11:15,16:65)], rep(c(1,0), c(5, 50)))
      if (effect == "moderate") pred <- prediction(VI[c(6:10, 16:65)], rep(c(1,0), c(5, 50)))
      if (effect == "strong")   pred <- prediction(VI[c(1:5,  16:65)], rep(c(1,0), c(5, 50)))
      
      return(unlist(performance(pred, measure = "auc")@y.values))
      
}
