######################################################################################
#                                                                                    #
# Main function: for plotting distr. of AUCs for both VIMs & for different imbalance #
#                                                                                    #
# Input: - list of R objects (created in previous section)                           #
#        - specification which effects are to be distinguished from noise predictors #
#          chose between effect strength ''all''/''weak''/''moderate''/''strong''    #
#        - name of the file (or path where it shall be saved)                        #
#        - heading of plot                                                           #
#                                                                                    #
# Output: plot of AUC distributions                                                  #
#                                                                                    #
######################################################################################


plot_AUC_eval_early_stopping <- function(liste = list500,
                          effect     = "all",
                          filename   = "filename",
                          xlabname   = "minbucket",
                          plotmain   = "plotmain",
                          labelnames = c("0","5","10","20","30","40","50")){
                            
  graphics.off()
 
  pdf(file = paste(filename, ".pdf", sep = ""), width = 6, height = 6)
  par(cex.axis = 1.5, cex.main = 1.5, cex.lab = 1.5, mar = c(5,4.5,4,2))

  nolevels <- length(liste)

  plot.new()
  plot.window(xlim = c(0, nolevels * 3), ylim = c(0.2,1))

  axis(1, at = 3 * ((1:nolevels) - 0.5), labels = labelnames)

  abline(h = 1,   lty = 2)    
  abline(h = 0.5, lty = 2, col = "darkgrey")

  for (i in 1:nolevels){

  boxplot(apply(liste[[i]]$AUC_VI, 2, function(x) get_AUC(VI = x, effect = effect)),
          apply(liste[[i]]$ER_VI, 2,  function(x) get_AUC(VI = x, effect = effect)),
          add   = TRUE,
          at    = 1:2 + 3 * (i-1),
          ylim  = c(0,1),
          col   = c("lightgrey", "white"),
          main  = plotmain,
          ylab  = "AUC",
          xlab  = xlabname,
          xaxt  = "n")
  }

  graphics.off()
  
}