###############################################################################
#                                                                             #
#   Reproducible files to the paper 'Pitfalls of hypothesis tests             #
#   and model selection on bootstrap samples: causes and consequences in      #
#   biometrical applications'  (2014)                                         #
#   by Janitza, Binder and Boulesteix                                         #
#                                                                             #
#   Contact: S. Janitza <janitza@ibe.med.uni-muenchen.de>                     #
#                                                                             #
#   File for reproducing Figure 13 (Part 2)                                   #
#                                                                             #
###############################################################################


# uncomment the following line and set the working directory where the R objects are stored
# setwd("...") 


# create Figure 13: setting with weak effects (save e.g. as pdf of size 6x3.2)

# load relevant R objects
load("AIC_setting_uncor_weak_p200.Rda")
load("AIC_setting_uncor_weak_p1000.Rda")
load("AIC_setting_uncor_weak_p5000.Rda")

par(mfrow = c(1, 3), mar = c(5, 4, 2, 0.1), oma = c(0, 0, 0, 0), cex.lab = 1, cex.axis = 1)

lablist <- c("original", "bootstrap", "subsample")

boxplot(AIC_setting_uncor_weak_p200, xaxt = "n", ylim = c(0, 1000), ylab = "Optimal number of boosting steps", main = "p = 200")
axis(1, at = seq(1, 3, by = 1), labels = FALSE)
text(seq(0.9, 2.9, by = 1), -130, labels = lablist, srt = 45, pos = 1, xpd = TRUE, cex = 0.9)

boxplot(AIC_setting_uncor_weak_p1000, xaxt = "n", ylim = c(0, 800), ylab = "", main = "p = 1000")
axis(1, at = seq(1, 3, by = 1), labels = FALSE)
text(seq(0.9, 2.9, by = 1), -108, labels = lablist, srt = 45, pos = 1, xpd = TRUE, cex = 0.9)

boxplot(AIC_setting_uncor_weak_p5000, xaxt = "n", ylim = c(0, 600), ylab = "", main = "p = 5000")
axis(1, at = seq(1, 3, by = 1), labels = FALSE)
text(seq(0.9, 2.9, by = 1), -80, labels = lablist, srt = 45, pos = 1, xpd = TRUE, cex = 0.9)



# setting with medium effects (not shown in the paper)

# load relevant R objects
load("AIC_setting_uncor_medium_p200.Rda")
load("AIC_setting_uncor_medium_p1000.Rda")
load("AIC_setting_uncor_medium_p5000.Rda")

par(mfrow = c(1, 3), mar = c(5, 4, 2, 0.1), oma = c(0, 0, 0, 0), cex.lab = 1, cex.axis = 1)

lablist <- c("original", "bootstrap", "subsample")

boxplot(AIC_setting_uncor_medium_p200, xaxt = "n", ylim = c(0, 1000), ylab = "Optimal number of boosting steps", main = "p = 200")
axis(1, at = seq(1, 3, by = 1), labels = FALSE)
text(seq(0.9, 2.9, by = 1), -130, labels = lablist, srt = 45, pos = 1, xpd = TRUE, cex = 0.9)

boxplot(AIC_setting_uncor_medium_p1000, xaxt = "n", ylim = c(0, 800), ylab = "", main = "p = 1000")
axis(1, at = seq(1, 3, by = 1), labels = FALSE)
text(seq(0.9, 2.9, by = 1), -108, labels = lablist, srt = 45, pos = 1, xpd = TRUE, cex = 0.9)

boxplot(AIC_setting_uncor_medium_p5000, xaxt = "n", ylim = c(0, 600), ylab = "", main = "p = 5000")
axis(1, at = seq(1, 3, by = 1), labels = FALSE)
text(seq(0.9, 2.9, by = 1), -80, labels = lablist, srt = 45, pos = 1, xpd = TRUE, cex = 0.9)

