#################################################################################
#                                                                               #
#   Reproducible files to the paper 'A computationally fast variable            #
#   importance test for random forests for high-dimensional data' (2015)        #
#   by Janitza, Celik and Boulesteix                                            #
#                                                                               #
#   Contact: S. Janitza <janitza@ibe.med.uni-muenchen.de>                       #
#                                                                               #
#   File for creating Figures 4, B.3, B.12, B.13                                #
#                                                                               #
#################################################################################

# load relevant R package 
library(vita)
library(ROCR)

# source the functions used for plotting the results 
source("functions_plot.R")

# load relevant R objects
for(i in grep("studyII_", dir("../results/"))) load(paste("../results/", dir("../results/")[i], sep = ""))
for(i in grep("studyIII_", dir("../results/"))) load(paste("../results/", dir("../results/")[i], sep = ""))

######################################################################################################################################
#
#                                                       F I G U R E   4
#
######################################################################################################################################

graphics.off()
pdf(file = "Fig4.pdf", height = 5, width = 9)

par(mfrow = c(1, 2), mar = c(7.5, 4, 3, 1), bty = "l")

boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_prostate[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_prostate[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_breast[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_breast[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_leukemia[[z]]$cv_varim,
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_leukemia[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_colon[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_colon[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_cns[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_cns[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_smallmtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.66), main = "Study II")

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)


boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_prostate[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_prostate[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_breast[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_breast[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_leukemia[[z]]$cv_varim,
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_leukemia[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_colon[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_colon[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_cns[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_cns[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_smallmtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.66), main = "Study III")

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)

legend("topright", legend = c("hold-out", "classical"), fill = c("gray90", "gray50"), cex = 0.8, bty = "n")

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B.3
#
######################################################################################################################################

graphics.off()
pdf(file = "FigB3.pdf", height = 5, width = 9)

par(mfrow = c(1, 2), mar = c(7.5, 4, 3, 1), bty = "l")

boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_prostate[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_prostate[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_breast[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_breast[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_leukemia[[z]]$cv_varim,
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_leukemia[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_colon[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_colon[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_cns[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_cns[[z]], 
                                                              rep(c(1,0), c(100, (length(studyII_classical_largemtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.66), main = "Study II")

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)


boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_prostate[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_prostate[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_prostate[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_breast[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_breast[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_breast[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_leukemia[[z]]$cv_varim,
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_leukemia[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_leukemia[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_colon[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_colon[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_colon[[z]]) - 100)))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_cns[[z]]$cv_varim, 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_cns[[z]], 
                                                              rep(c(1,0), c(100, (length(studyIII_classical_largemtry_largeeffects_cns[[z]]) - 100)))),"auc")@y.values[[1]])),
  col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.66), main = "Study III")

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)

legend("topright", legend = c("hold-out", "classical"), fill = c("gray90", "gray50"), cex = 0.8, bty = "n")

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B.12
#
######################################################################################################################################

graphics.off()
pdf(file = "FigB12.pdf", height = 5, width = 9)

par(mfrow = c(1, 2), mar = c(7.5, 4, 3, 1), bty = "l")

boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_p100_prostate[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_p100_prostate[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_p100_breast[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_p100_breast[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_p100_leukemia[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_p100_leukemia[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_p100_colon[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_p100_colon[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_smallmtry_largeeffects_p100_cns[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_smallmtry_largeeffects_p100_cns[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.9), main = expression(paste("mtry = ", sqrt(100))))

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)


boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_p100_prostate[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_p100_prostate[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_p100_breast[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_p100_breast[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_p100_leukemia[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_p100_leukemia[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_p100_colon[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_p100_colon[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_cv2_largemtry_largeeffects_p100_cns[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyII_classical_largemtry_largeeffects_p100_cns[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.9), main = expression(paste("mtry = ", 100/5)))

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)
legend("topright", legend = c("hold-out", "classical"), fill = c("gray90", "gray50"), cex = 0.8, bty = "n")

graphics.off()

######################################################################################################################################
#
#                                                       F I G U R E   B.13
#
######################################################################################################################################

graphics.off()
pdf(file = "FigB13.pdf", height = 5, width = 9)

par(mfrow = c(1, 2), mar = c(7.5, 4, 3, 1), bty = "l")

boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_p100_prostate[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_p100_prostate[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_p100_breast[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_p100_breast[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_p100_leukemia[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_p100_leukemia[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_p100_colon[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_p100_colon[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_smallmtry_largeeffects_p100_cns[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_smallmtry_largeeffects_p100_cns[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.9), main = expression(paste("mtry = ", sqrt(100))))

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)


boxplot(
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_p100_prostate[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_p100_prostate[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_p100_breast[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_p100_breast[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_p100_leukemia[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_p100_leukemia[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_p100_colon[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_p100_colon[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        NA,
  as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_cv2_largemtry_largeeffects_p100_cns[[z]]$cv_varim, rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        as.numeric(sapply(1:500, function(z) performance(prediction(studyIII_classical_largemtry_largeeffects_p100_cns[[z]], rep(c(1,0), c(20, 80))),"auc")@y.values[[1]])),
        col = c("gray90", "gray50", "gray50"), ylab = "AUC", xaxt = "n", ylim = c(0.42, 0.9), main = expression(paste("mtry = ", 100/5)))

abline(h = 0.5, lty = 3)
axis(side = 1, labels = c("Prostate Cancer", "Breast Cancer", "Leukemia", "Colon Cancer", "Embryonal Tumor"), at = c(1.5, 4.5, 7.5, 10.5, 13.5), las = 2)
legend("topright", legend = c("hold-out", "classical"), fill = c("gray90", "gray50"), cex = 0.8, bty = "n")

graphics.off()

