#################################################################################
#                                                                               #
#   Reproducible files to the paper 'A computationally fast variable            #
#   importance test for random forests for high-dimensional data' (2015)        #
#   by Janitza, Celik and Boulesteix                                            #
#                                                                               #
#   Contact: S. Janitza <janitza@ibe.med.uni-muenchen.de>                       #
#                                                                               #
#   File for creating Figures 3, B.2                                            #
#                                                                               #
#################################################################################

# load relevant R package 
library(vita)

# source the functions used for plotting the results 
source("functions_plot.R")

# load relevant R objects
for(i in grep("studyI_", dir("../results/"))) load(paste("../results/", dir("../results/")[i], sep = ""))

######################################################################################################################################
#
#                                                       F I G U R E   3
#
######################################################################################################################################

graphics.off()
tiff("Fig3.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
#png("Fig3.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_largemtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_largemtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.005, 0.005), ylim = c(-0.005, 0.005))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_largemtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_largemtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_largemtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_largemtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_largemtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_largemtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B2
#
######################################################################################################################################

graphics.off()
tiff("FigB2.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("FigB2.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_smallmtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_smallmtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.003, 0.003), ylim = c(-0.003, 0.003))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_smallmtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_smallmtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.004, 0.004), ylim = c(-0.004, 0.004), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_smallmtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_smallmtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.004, 0.004), ylim = c(-0.004, 0.004), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_smallmtry_colon[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_smallmtry_colon[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.004, 0.004), ylim = c(-0.004, 0.004), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()



######################################################################################################################################
#
#                                   A D D I T I O N A L   F I G U R E S  ( N O T  S H O W N   I N  P A P E R )
#
######################################################################################################################################


### for prostate cancer data

# small mtry 

graphics.off()
tiff("add_prostate_smallmtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_prostate_smallmtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_smallmtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_smallmtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.002, 0.002), ylim = c(-0.002, 0.002))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_smallmtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_smallmtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_smallmtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_smallmtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_smallmtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_smallmtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()


# large mtry 

graphics.off()
tiff("add_prostate_largemtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_prostate_largemtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_largemtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_largemtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.004, 0.004), ylim = c(-0.004, 0.004))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_largemtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_largemtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.0055, 0.0055), ylim = c(-0.0055, 0.0055), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_largemtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_largemtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.0055, 0.0055), ylim = c(-0.0055, 0.0055), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_largemtry_prostate[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_largemtry_prostate[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.0055, 0.0055), ylim = c(-0.0055, 0.0055), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()



### for breast cancer data

# small mtry 

graphics.off()
tiff("add_breast_smallmtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_breast_smallmtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_smallmtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_smallmtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.002, 0.002), ylim = c(-0.002, 0.002))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_smallmtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_smallmtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_smallmtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_smallmtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_smallmtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_smallmtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()


# large mtry 

graphics.off()
tiff("add_breast_largemtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_breast_largemtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_largemtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_largemtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.004, 0.004), ylim = c(-0.004, 0.004))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_largemtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_largemtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_largemtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_largemtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_largemtry_breast[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_largemtry_breast[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()



### for leukemia data

# small mtry 

graphics.off()
tiff("add_leukemia_smallmtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_leukemia_smallmtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_smallmtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_smallmtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.002, 0.002), ylim = c(-0.002, 0.002))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_smallmtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_smallmtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_smallmtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_smallmtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_smallmtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_smallmtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()


# large mtry 

graphics.off()
tiff("add_leukemia_largemtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_leukemia_largemtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_largemtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_largemtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.004, 0.004), ylim = c(-0.004, 0.004))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_largemtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_largemtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_largemtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_largemtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_largemtry_leukemia[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_largemtry_leukemia[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()



### for embryonal tumor data

# small mtry 

graphics.off()
tiff("add_embryonaltumor_smallmtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_embryonaltumor_smallmtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_smallmtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_smallmtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.002, 0.002), ylim = c(-0.002, 0.002))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_smallmtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_smallmtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_smallmtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_smallmtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_smallmtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_smallmtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.0025, 0.0025), ylim = c(-0.0025, 0.0025), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()


# large mtry

graphics.off()
tiff("add_embryonaltumor_largemtry.tiff", height = 12, width = 40, units = 'cm', compression = "lzw", res = 300) 
# png("add_embryonaltumor_largemtry.png", height = 12, width = 40, units = 'cm', res = 300)

par(mfrow = c(1, 4), cex.main = 3, cex.axis = 2, cex.lab = 3, mar = c(6, 6, 2, 1), bty = "l")

plot(y = sapply(1:500, function(z) studyI_cv2_largemtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv2_largemtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 2", xlab = "", ylab = "", xlim = c(-0.004, 0.004), ylim = c(-0.004, 0.004))
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv3_largemtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv3_largemtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 3", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv5_largemtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv5_largemtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 5", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

plot(y = sapply(1:500, function(z) studyI_cv10_largemtry_cns[[z]]$fold_varim[,1]), x = sapply(1:500, function(z) studyI_cv10_largemtry_cns[[z]]$fold_varim[,2]), 
     col = rgb(1, 1, 1, 40, maxColorValue = 255), pch = 16, cex = 0.4, main = "k = 10", xlim = c(-0.006, 0.006), ylim = c(-0.006, 0.006), xlab = "", ylab = "")
mtext(side = 1, text = expression(VI^{CV(2)}), cex = 2, line = 5)
mtext(side = 2, expression(VI^{CV(1)}), cex = 2, line = 2.5)

graphics.off()

